/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.StoredModelResourceBase;

public class ScriptedModel
implements StoredModelResourceBase {
    private final ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> models;

    public ScriptedModel(Identifier location, boolean flipV) {
        this.models = this.load(location.getNamespace() + ":" + location.getPath(), "", flipV, 0.0, ResourceManagerHelper::readResource);
    }

    public OptimizedModelWrapper getOptimizedModel() {
        return (OptimizedModelWrapper)this.models.left();
    }

    public DynamicVehicleModel getDynamicVehicleModel() {
        return (DynamicVehicleModel)this.models.right();
    }

    public void preload() {
    }

    public void draw(StoredMatrixTransformations storedMatrixTransformations, int light) {
        DynamicVehicleModel dynamicVehicleModel = this.getDynamicVehicleModel();
        OptimizedModelWrapper optimizedModelWrapper = this.getOptimizedModel();
        if (OptimizedRenderer.hasOptimizedRendering()) {
            if (optimizedModelWrapper != null) {
                MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolder, offset);
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue(optimizedModelWrapper, graphicsHolder, light);
                    graphicsHolder.pop();
                });
            }
        } else if (dynamicVehicleModel != null) {
            MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform(graphicsHolder, offset);
                dynamicVehicleModel.render(graphicsHolder, light, 0, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolder.pop();
            });
        }
    }
}

