/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.data.pids.preset.components;

import com.google.gson.JsonObject;
import fabric.com.lx862.jcm.mod.data.KVPair;
import fabric.com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import fabric.com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import fabric.com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import org.mtr.core.data.Route;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.generated.lang.TranslationProvider;

public class ArrivalDestinationComponent
extends TextComponent {
    private final int arrivalIndex;

    public ArrivalDestinationComponent(double x, double y, double width, double height, KVPair additionalParam) {
        super(x, y, width, height, additionalParam);
        this.arrivalIndex = additionalParam.getInt("arrivalIndex", 0);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, PIDSContext context) {
        ObjectArrayList<ArrivalResponse> arrivals = context.arrivals;
        if (this.arrivalIndex >= arrivals.size()) {
            return;
        }
        ArrivalResponse arrival = (ArrivalResponse)arrivals.get(this.arrivalIndex);
        String destinationString = this.getDestinationString(arrival);
        if (arrival.getCircularState() == Route.CircularState.CLOCKWISE) {
            destinationString = (this.isCjk(destinationString, false) ? TranslationProvider.GUI_MTR_CLOCKWISE_VIA_CJK : TranslationProvider.GUI_MTR_CLOCKWISE_VIA).getString(new Object[]{destinationString});
        } else if (arrival.getCircularState() == Route.CircularState.ANTICLOCKWISE) {
            destinationString = (this.isCjk(destinationString, false) ? TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA_CJK : TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA).getString(new Object[]{destinationString});
        }
        this.drawText(graphicsHolder, guiDrawing, facing, destinationString);
    }

    public String getDestinationString(ArrivalResponse arrival) {
        String routeNo = arrival.getRouteNumber().isEmpty() ? "" : arrival.getRouteNumber() + " ";
        return this.cycleString(routeNo) + this.cycleString(arrival.getDestination());
    }

    public static PIDSComponent parseComponent(double x, double y, double width, double height, JsonObject jsonObject) {
        return new ArrivalDestinationComponent(x, y, width, height, new KVPair(jsonObject));
    }
}

