/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.data.pids.preset.components;

import com.google.gson.JsonObject;
import fabric.com.lx862.jcm.mod.data.KVPair;
import fabric.com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import fabric.com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import fabric.com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import fabric.com.lx862.jcm.mod.render.text.TextAlignment;
import fabric.com.lx862.jcm.mod.render.text.TextOverflowMode;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class PlatformComponent
extends TextComponent {
    private final int arrivalIndex;

    public PlatformComponent(double x, double y, double width, double height, String font, int textColor, double scale, KVPair additionalParam) {
        super(x, y, width, height, TextComponent.of(TextAlignment.CENTER, TextOverflowMode.SCALE, font, textColor, scale));
        this.arrivalIndex = additionalParam.getInt("arrivalIndex", 0);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, PIDSContext context) {
        ArrivalResponse arrival = (ArrivalResponse)Utilities.getElement(context.arrivals, (int)this.arrivalIndex);
        if (arrival == null) {
            return;
        }
        graphicsHolder.translate(this.width / 1.6, 2.0, 0.0);
        this.drawText(graphicsHolder, guiDrawing, facing, arrival.getPlatformName());
    }

    public static PIDSComponent parseComponent(double x, double y, double width, double height, JsonObject jsonObject) {
        String font = jsonObject.get("font").getAsString();
        int textColor = jsonObject.get("color").getAsInt();
        double scale = jsonObject.get("scale").getAsDouble();
        return new PlatformComponent(x, y, width, height, font, textColor, scale, new KVPair(jsonObject));
    }
}

