/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.data.pids.preset.components.base;

import fabric.com.lx862.jcm.mod.JCMClient;
import fabric.com.lx862.jcm.mod.data.KVPair;
import fabric.com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import fabric.com.lx862.jcm.mod.render.RenderHelper;
import fabric.com.lx862.jcm.mod.render.text.TextAlignment;
import fabric.com.lx862.jcm.mod.render.text.TextInfo;
import fabric.com.lx862.jcm.mod.render.text.TextOverflowMode;
import fabric.com.lx862.jcm.mod.render.text.TextRenderingManager;
import fabric.com.lx862.jcm.mod.render.text.TextTranslationMode;
import java.util.ArrayList;
import java.util.Arrays;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.InitClient;
import org.mtr.mod.data.IGui;

public abstract class TextComponent
extends PIDSComponent {
    public static final int SWITCH_LANG_DURATION = 60;
    protected final TextOverflowMode textOverflowMode;
    protected final TextAlignment textAlignment;
    protected final TextTranslationMode textTranslationMode;
    protected final String font;
    protected final int textColor;
    protected final double scale;

    public TextComponent(double x, double y, double width, double height, KVPair additionalParam) {
        super(x, y, width, height);
        this.font = additionalParam.get("font", "");
        this.textAlignment = TextAlignment.valueOf(additionalParam.get("textAlignment", "LEFT"));
        this.textOverflowMode = TextOverflowMode.valueOf(additionalParam.get("textOverflowMode", "STRETCH"));
        this.textTranslationMode = TextTranslationMode.valueOf(additionalParam.get("textTranslationMode", "CYCLE"));
        this.scale = additionalParam.getDouble("scale", 1.0);
        this.textColor = additionalParam.getColor("color", 0);
    }

    public static KVPair of(TextAlignment textAlignment, TextOverflowMode textOverflowMode, String font, int textColor, double scale) {
        return new KVPair().with("textAlignment", textAlignment.name()).with("textOverflowMode", textOverflowMode.name()).with("font", font).with("color", textColor).with("scale", scale);
    }

    protected void drawText(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, String text) {
        this.drawText(graphicsHolder, guiDrawing, facing, new TextInfo(this.cycleString(text)));
    }

    protected void drawText(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, TextInfo text) {
        TextRenderingManager.bind(graphicsHolder);
        TextInfo finalText = text.withColor(this.textColor + -16777216).withFont(this.font).withTextAlignment(this.textAlignment);
        graphicsHolder.push();
        graphicsHolder.translate(this.x, this.y, 0.0);
        graphicsHolder.scale((float)this.scale, (float)this.scale, (float)this.scale);
        double textWidth = TextRenderingManager.getTextWidth(finalText);
        if (this.textOverflowMode == TextOverflowMode.MARQUEE && textWidth > this.width) {
            finalText = finalText.withScrollingText().withMaxWidth((float)this.width);
        } else {
            RenderHelper.scaleToFit(graphicsHolder, textWidth, this.width, this.textOverflowMode == TextOverflowMode.SCALE, 14.0);
        }
        if (guiDrawing != null) {
            if (JCMClient.getConfig().useNewTextRenderer) {
                TextRenderingManager.draw(graphicsHolder, guiDrawing, finalText, this.x, this.y);
            } else {
                TextRenderingManager.draw(graphicsHolder, guiDrawing, finalText, 0.0, 0.0);
            }
        } else {
            TextRenderingManager.draw(graphicsHolder, finalText, facing, 0.0, 0.0);
        }
        graphicsHolder.pop();
    }

    protected String cycleString(String mtrString, boolean isForTranslation) {
        if (this.textTranslationMode == TextTranslationMode.MERGE) {
            return mtrString.replace("|", " ");
        }
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(mtrString.split("\\|")));
        if (this.textTranslationMode != TextTranslationMode.CYCLE) {
            for (String lang : new ArrayList<String>(split)) {
                if (this.textTranslationMode == TextTranslationMode.CJK && !this.isCjk(lang, isForTranslation)) {
                    split.remove(lang);
                }
                if (this.textTranslationMode != TextTranslationMode.NON_CJK || !this.isCjk(lang, isForTranslation)) continue;
                split.remove(lang);
            }
        }
        if (split.isEmpty()) {
            return "";
        }
        return (String)split.get((int)InitClient.getGameTick() / 60 % split.size());
    }

    protected boolean isCjk(String str, boolean isTranslation) {
        if (isTranslation) {
            return str.endsWith("_cjk");
        }
        return IGui.isCjk((String)str);
    }

    protected String cycleString(String ... string) {
        return this.cycleString(String.join((CharSequence)"|", string), false);
    }

    protected String cycleStringTranslation(String ... string) {
        return this.cycleString(String.join((CharSequence)"|", string), true);
    }
}

