/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.network.block;

import fabric.com.lx862.jcm.mod.block.base.JCMBlock;
import fabric.com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import fabric.com.lx862.jcm.mod.network.JCMPacketHandlerHelper;
import fabric.com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class PIDSUpdatePacket
extends PacketHandler {
    protected final BlockPos blockPos;
    protected final LongAVLTreeSet filteredPlatforms;
    protected final String[] customMessages;
    protected final boolean[] rowHidden;
    protected final boolean hidePlatformNumber;
    protected final String presetId;

    public PIDSUpdatePacket(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int rows = packetBufferReceiver.readInt();
        this.customMessages = new String[rows];
        this.rowHidden = new boolean[rows];
        this.filteredPlatforms = new LongAVLTreeSet();
        JCMPacketHandlerHelper.readArray(packetBufferReceiver, i -> {
            this.customMessages[i.intValue()] = packetBufferReceiver.readString();
        });
        JCMPacketHandlerHelper.readArray(packetBufferReceiver, i -> {
            this.rowHidden[i.intValue()] = packetBufferReceiver.readBoolean();
        });
        JCMPacketHandlerHelper.readArray(packetBufferReceiver, i -> this.filteredPlatforms.add(packetBufferReceiver.readLong()));
        this.hidePlatformNumber = packetBufferReceiver.readBoolean();
        this.presetId = packetBufferReceiver.readString();
    }

    public PIDSUpdatePacket(BlockPos blockPos, LongAVLTreeSet filteredPlatforms, String[] customMessages, boolean[] rowHidden, boolean hidePlatformNumber, String pidsPreset) {
        this.blockPos = blockPos;
        this.customMessages = customMessages;
        this.rowHidden = rowHidden;
        this.presetId = pidsPreset;
        this.hidePlatformNumber = hidePlatformNumber;
        this.filteredPlatforms = filteredPlatforms;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.customMessages.length);
        JCMPacketHandlerHelper.writeArray(packetBufferSender, this.customMessages, i -> packetBufferSender.writeString(this.customMessages[i]));
        JCMPacketHandlerHelper.writeArray(packetBufferSender, this.rowHidden, i -> packetBufferSender.writeBoolean(this.rowHidden[i]));
        JCMPacketHandlerHelper.writeArray(packetBufferSender, this.filteredPlatforms, arg_0 -> ((PacketBufferSender)packetBufferSender).writeLong(arg_0));
        packetBufferSender.writeBoolean(this.hidePlatformNumber);
        packetBufferSender.writeString(this.presetId);
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = serverPlayerEntity.getEntityWorld();
        BlockState state = BlockUtil.getBlockState(world, this.blockPos);
        if (state == null || !(state.getBlock().data instanceof JCMBlock)) {
            return;
        }
        ((JCMBlock)((Object)state.getBlock().data)).loopStructure(state, world, this.blockPos, (bs, be) -> {
            if (be.data instanceof PIDSBlockEntity) {
                ((PIDSBlockEntity)((Object)((Object)be.data))).setData(this.customMessages, this.filteredPlatforms, this.rowHidden, this.hidePlatformNumber, this.presetId);
            }
        });
    }
}

