/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.registry;

import fabric.com.lx862.jcm.mod.network.block.ButterflyLightUpdatePacket;
import fabric.com.lx862.jcm.mod.network.block.FareSaverUpdatePacket;
import fabric.com.lx862.jcm.mod.network.block.OperatorButtonUpdatePacket;
import fabric.com.lx862.jcm.mod.network.block.PIDSProjectorUpdatePacket;
import fabric.com.lx862.jcm.mod.network.block.PIDSUpdatePacket;
import fabric.com.lx862.jcm.mod.network.block.SoundLooperUpdatePacket;
import fabric.com.lx862.jcm.mod.network.block.SubsidyMachineUpdatePacket;
import fabric.com.lx862.jcm.mod.network.gui.ButterflyLightGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.EnquiryUpdateGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.FareSaverGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.OperatorButtonGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.PIDSGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.PIDSProjectorGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.SoundLooperGUIPacket;
import fabric.com.lx862.jcm.mod.network.gui.SubsidyMachineGUIPacket;
import fabric.com.lx862.jcm.mod.registry.JCMRegistry;
import fabric.com.lx862.jcm.mod.registry.JCMRegistryClient;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.PacketBufferReceiver;

public class Networking {
    private static final List<String> registeredPackets = new ArrayList<String>();

    public static void register() {
        JCMLogger.debug("Registering network packets...", new Object[0]);
        JCMRegistry.setupPacket();
        Networking.registerPacket(ButterflyLightUpdatePacket.class, ButterflyLightUpdatePacket::new);
        Networking.registerPacket(EnquiryUpdateGUIPacket.class, EnquiryUpdateGUIPacket::new);
        Networking.registerPacket(FareSaverUpdatePacket.class, FareSaverUpdatePacket::new);
        Networking.registerPacket(OperatorButtonUpdatePacket.class, OperatorButtonUpdatePacket::new);
        Networking.registerPacket(PIDSUpdatePacket.class, PIDSUpdatePacket::new);
        Networking.registerPacket(PIDSProjectorUpdatePacket.class, PIDSProjectorUpdatePacket::new);
        Networking.registerPacket(SoundLooperUpdatePacket.class, SoundLooperUpdatePacket::new);
        Networking.registerPacket(SubsidyMachineUpdatePacket.class, SubsidyMachineUpdatePacket::new);
        Networking.registerPacket(ButterflyLightGUIPacket.class, ButterflyLightGUIPacket::new);
        Networking.registerPacket(FareSaverGUIPacket.class, FareSaverGUIPacket::new);
        Networking.registerPacket(OperatorButtonGUIPacket.class, OperatorButtonGUIPacket::new);
        Networking.registerPacket(PIDSGUIPacket.class, PIDSGUIPacket::new);
        Networking.registerPacket(PIDSProjectorGUIPacket.class, PIDSProjectorGUIPacket::new);
        Networking.registerPacket(SoundLooperGUIPacket.class, SoundLooperGUIPacket::new);
        Networking.registerPacket(SubsidyMachineGUIPacket.class, SubsidyMachineGUIPacket::new);
    }

    public static void registerClient() {
        JCMRegistryClient.setupPacketClient();
    }

    private static <T extends PacketHandler> void registerPacket(Class<T> classObject, Function<PacketBufferReceiver, T> getInstance) {
        registeredPackets.add(classObject.getName());
        JCMRegistry.registerPacket(classObject, getInstance);
    }

    public static <T extends PacketHandler> void sendPacketToServer(T data) {
        if (!registeredPackets.contains(data.getClass().getName())) {
            JCMLogger.warn("Non-registered packets is sent: " + data.getClass().getName(), new Object[0]);
            JCMLogger.warn("Consider registering in method: mod/registry/Networking.register()", new Object[0]);
        }
        JCMRegistryClient.REGISTRY_CLIENT.sendPacketToServer(data);
    }

    public static <T extends PacketHandler> void sendPacketToClient(PlayerEntity player, T data) {
        if (!registeredPackets.contains(data.getClass().getName())) {
            JCMLogger.warn("Non-registered packets is sent: " + data.getClass().getName(), new Object[0]);
            JCMLogger.warn("Consider registering in method: mod/registry/Networking.register()", new Object[0]);
        }
        JCMRegistry.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), data);
    }
}

