/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render;

import fabric.com.lx862.jcm.mod.JCMClient;
import fabric.com.lx862.jcm.mod.data.Pair;
import fabric.com.lx862.jcm.mod.render.ClipStack;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public interface GuiHelper {
    public static final int MAX_CONTENT_WIDTH = 400;
    public static final int BOTTOM_ROW_MARGIN = 6;
    public static final int MAX_BUTTON_WIDTH = 375;
    public static final int MAX_ALPHA = -16777216;

    public static void drawTexture(GuiDrawing guiDrawing, Identifier identifier, double x, double y, double width, double height) {
        Pair<Float, Float> uv = JCMClient.getMcMetaManager().getUV(identifier);
        GuiHelper.drawTexture(guiDrawing, identifier, x, y, width, height, 0.0f, uv.getLeft().floatValue(), 1.0f, uv.getRight().floatValue());
    }

    public static void drawTexture(GuiDrawing guiDrawing, Identifier identifier, double x, double y, double width, double height, float u1, float v1, float u2, float v2) {
        guiDrawing.beginDrawingTexture(identifier);
        guiDrawing.drawTexture(x, y, x + width, y + height, u1, v1, u2, v2);
        guiDrawing.finishDrawingTexture();
    }

    public static void drawRectangle(GuiDrawing guiDrawing, double x, double y, double width, double height, int color) {
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(x, y, x + width, y + height, color);
        guiDrawing.finishDrawingRectangle();
    }

    public static void drawScrollableText(GraphicsHolder graphicsHolder, MutableText text, double elapsed, int startX, int textX, int textY, int maxW, int color, boolean shadow) {
        int textWidth = GraphicsHolder.getTextWidth((MutableText)text);
        if (textWidth > maxW) {
            double slideProgress = Math.sin(elapsed / 4.0) / 2.0 + 0.5;
            graphicsHolder.translate(-slideProgress * (double)(textWidth - maxW), 0.0, 0.0);
            ClipStack.add(startX, 0, maxW, 500);
            graphicsHolder.drawText(text, textX, textY, color, shadow, 0xF000F0);
            ClipStack.pop();
        } else {
            graphicsHolder.drawText(text, textX, textY, color, shadow, 0xF000F0);
        }
    }

    public static int getButtonWidth(double width) {
        return (int)Math.min(375.0, width);
    }
}

