/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render.gui.screen;

import fabric.com.lx862.jcm.mod.Constants;
import fabric.com.lx862.jcm.mod.data.TransactionEntry;
import fabric.com.lx862.jcm.mod.render.GuiHelper;
import fabric.com.lx862.jcm.mod.render.gui.screen.base.AnimatedScreen;
import fabric.com.lx862.jcm.mod.util.TextCategory;
import fabric.com.lx862.jcm.mod.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.List;
import net.minecraft.class_339;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.data.IGui;

public class EnquiryScreen
extends AnimatedScreen {
    private static final int BACKGROUND_COLOR = -16561438;
    private static final int CONTENT_WIDTH = 260;
    private static final int CONTENT_HEIGHT = 200;
    private static final Identifier font = Constants.id("pids_lcd");
    private final List<TransactionEntry> entries;
    private final ButtonWidgetExtension doneButton;
    private final int remainingBalance;

    public EnquiryScreen(BlockPos pos, List<TransactionEntry> entries, int remainingBalance) {
        super(false);
        this.entries = entries;
        this.remainingBalance = remainingBalance;
        this.doneButton = new ButtonWidgetExtension(0, 0, 200, 20, TextUtil.translatable("gui.done", new Object[0]), btn -> this.onClose2());
    }

    protected void init2() {
        this.doneButton.setX2(this.getWidthMapped() / 2 - this.doneButton.getWidth2() / 2);
        this.doneButton.setY2(this.getHeightMapped() - this.doneButton.getHeight2() - 10);
        this.addChild(new ClickableWidget((class_339)this.doneButton));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.renderBackground(graphicsHolder);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        int screenWidth = this.getWidthMapped();
        int screenHeight = this.getHeightMapped();
        int scaleWidth = 475;
        float scaleFactor = Math.min(1.75f, (float)((double)this.getWidthMapped()) / (float)scaleWidth);
        int scaledEnquiryScreenWidth = (int)(260.0f * scaleFactor);
        int scaledEnquiryScreenHeight = (int)(200.0f * scaleFactor);
        GuiHelper.drawRectangle(guiDrawing, (double)(screenWidth - scaledEnquiryScreenWidth) / 2.0, (double)(screenHeight - scaledEnquiryScreenHeight) / 2.0, scaledEnquiryScreenWidth, scaledEnquiryScreenHeight, -16561438);
        graphicsHolder.drawCenteredText(TextUtil.translatable(TextCategory.BLOCK, "mtr_enquiry_machine", new Object[0]), this.getWidthMapped() / 2, (screenHeight - scaledEnquiryScreenHeight) / 2 / 2, -1);
        int startX = 5;
        int startY = 5;
        graphicsHolder.push();
        graphicsHolder.translate((double)(screenWidth - scaledEnquiryScreenWidth) / 2.0, (double)(screenHeight - scaledEnquiryScreenHeight) / 2.0, 0.0);
        graphicsHolder.scale(scaleFactor, scaleFactor, scaleFactor);
        String balancePrefix = this.remainingBalance >= 0 ? "" : "-";
        graphicsHolder.drawText(TextUtil.withFont(TextUtil.translatable(TextCategory.GUI, "enquiry_screen.balance", balancePrefix + "$" + Math.abs(this.remainingBalance)), font), startX, startY, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TextUtil.withFont(TextUtil.translatable(TextCategory.GUI, "enquiry_screen.points", "0"), font), startX, startY += 14, -1, false, GraphicsHolder.getDefaultLight());
        startY += 14;
        for (int i = 0; i < 10 && i < this.entries.size(); ++i) {
            TransactionEntry entry = this.entries.get(i);
            graphicsHolder.drawText(TextUtil.withFont(TextUtil.literal(entry.getFormattedDate()), font), startX, startY + i * 14, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(TextUtil.withFont(TextUtil.literal(IGui.formatStationName((String)entry.source)), font), startX + 90, startY + i * 14, -1, false, GraphicsHolder.getDefaultLight());
            MutableText balText = TextUtil.withFont(entry.amount < 0L ? TextUtil.literal("-$" + (double)(-entry.amount)) : (entry.amount == 0L ? TextUtil.literal("$" + (double)entry.amount) : TextUtil.literal("+$" + (double)entry.amount)), font);
            int balTextWidth = GraphicsHolder.getTextWidth((MutableText)balText);
            graphicsHolder.drawText(balText, 260 - balTextWidth - 5, startY + i * 14, -1, false, GraphicsHolder.getDefaultLight());
        }
        long lastAddValueTime = 0L;
        for (TransactionEntry transactionEntry : this.entries) {
            if (transactionEntry.amount <= 0L || transactionEntry.time <= lastAddValueTime) continue;
            lastAddValueTime = transactionEntry.time;
        }
        if (lastAddValueTime != 0L) {
            String formattedDate = new SimpleDateFormat("dd/MM/yyyy").format(lastAddValueTime);
            graphicsHolder.drawText(TextUtil.withFont(TextUtil.translatable(TextCategory.GUI, "enquiry_screen.add_balance", formattedDate), font), startX, 185, -1, false, GraphicsHolder.getDefaultLight());
        }
        graphicsHolder.pop();
        super.render(graphicsHolder, mouseX, mouseY, tickDelta);
    }

    public boolean isPauseScreen2() {
        return false;
    }
}

