/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render.gui.screen.base;

import fabric.com.lx862.jcm.mod.render.gui.screen.base.ScreenBase;
import org.mtr.mapping.mapper.GraphicsHolder;

public abstract class AnimatedScreen
extends ScreenBase {
    protected double linearAnimationProgress = 0.0;
    protected double animationProgress;
    protected boolean closing = false;
    private final boolean shouldAnimate;

    public AnimatedScreen(boolean animatable) {
        this.shouldAnimate = animatable;
        this.animationProgress = animatable ? 0.0 : 1.0;
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.render(graphicsHolder, mouseX, mouseY, tickDelta);
        double frameDelta = tickDelta / 20.0f;
        if (!this.shouldAnimate) {
            this.linearAnimationProgress = 1.0;
        } else {
            double d = this.linearAnimationProgress = this.closing ? Math.max(0.0, this.linearAnimationProgress - frameDelta) : Math.min(1.0, this.linearAnimationProgress + frameDelta);
            if (this.linearAnimationProgress <= 0.0 && this.closing) {
                this.onClose2();
            }
        }
        this.animationProgress = this.getEaseAnimation();
    }

    @Override
    public void onClose2() {
        if (this.closing || !this.shouldAnimate) {
            super.onClose2();
        } else {
            this.closing = true;
        }
    }

    private double getEaseAnimation() {
        double x = this.linearAnimationProgress;
        return 1.0 - Math.pow(1.0 - x, 5.0);
    }
}

