/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render.gui.widget;

import fabric.com.lx862.jcm.mod.render.RenderHelper;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;

public class CoordTextField
extends TextFieldWidgetExtension
implements RenderHelper {
    private final long min;
    private final long max;
    private final int defaultValue;

    public CoordTextField(int x, int y, int width, int height, long min, long max, int defaultValue) {
        super(x, y, width, height, 16, TextCase.LOWER, null, String.valueOf(defaultValue));
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
    }

    public boolean charTyped2(char chr, int modifiers) {
        String prevValue = this.getText2();
        boolean bl = super.charTyped2(chr, modifiers);
        try {
            int val;
            String newString = new StringBuilder(this.getText2()).insert(this.getCursor2(), chr).toString().trim();
            String[] strSplit = newString.split("\\s+");
            if (strSplit.length > 1) {
                for (String s : strSplit) {
                    if (s.trim().isEmpty()) continue;
                    try {
                        Integer.parseInt(s.trim());
                    }
                    catch (Exception e) {
                        return bl;
                    }
                }
            }
            if ((long)(val = Integer.parseInt(newString)) < this.min || (long)val > this.max) {
                JCMLogger.debug("NumericTextField: Value too large or small", new Object[0]);
                this.setText2(prevValue);
                return false;
            }
        }
        catch (Exception e) {
            JCMLogger.error("", e);
            return false;
        }
        return bl;
    }

    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        if (this.getVisibleMapped() && this.getActiveMapped() && this.isFocused2()) {
            if (amount > 0.0) {
                this.increment();
            } else {
                this.decrement();
            }
        }
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    public int getNumber() {
        try {
            return Integer.parseInt(this.getText2());
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }

    public void setValue(long value) {
        if (value < this.min || value > this.max) {
            return;
        }
        this.setText2(String.valueOf(value));
    }

    private void increment() {
        try {
            this.setValue(Integer.parseInt(this.getText2()) + 1);
        }
        catch (Exception e) {
            this.setValue(this.defaultValue);
        }
    }

    private void decrement() {
        try {
            this.setValue(Integer.parseInt(this.getText2()) - 1);
        }
        catch (Exception e) {
            this.setValue(this.defaultValue);
        }
    }
}

