/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render.gui.widget;

import fabric.com.lx862.jcm.mod.render.RenderHelper;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import fabric.com.lx862.jcm.mod.util.TextCategory;
import fabric.com.lx862.jcm.mod.util.TextUtil;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;

public class IntegerTextField
extends TextFieldWidgetExtension
implements RenderHelper {
    private final long min;
    private final long max;
    private final String prefix;
    private final long defaultValue;

    public IntegerTextField(int x, int y, int width, int height, long min, long max, long defaultValue, @Nonnull String prefix) {
        super(x, y, width, height, 16, TextCase.LOWER, null, String.valueOf(defaultValue));
        this.min = min;
        this.max = max;
        this.prefix = prefix;
        this.defaultValue = defaultValue;
    }

    public IntegerTextField(int x, int y, int width, int height, int min, int max, int defaultValue, MutableText prefix) {
        this(x, y, width, height, (long)min, (long)max, (long)defaultValue, prefix.getString());
    }

    public IntegerTextField(int x, int y, int width, int height, int min, int max, int defaultValue) {
        this(x, y, width, height, (long)min, (long)max, (long)defaultValue, (String)null);
    }

    public boolean charTyped2(char chr, int modifiers) {
        String prevValue = this.getText2();
        boolean bl = super.charTyped2(chr, modifiers);
        try {
            String newString = this.getText2();
            int val = Integer.parseInt(newString);
            if ((long)val < this.min || (long)val > this.max) {
                JCMLogger.debug("NumericTextField: Value too large or small", new Object[0]);
                this.setText2(prevValue);
                return false;
            }
        }
        catch (Exception e) {
            this.setText2(prevValue);
            return false;
        }
        return bl;
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.render(graphicsHolder, mouseX, mouseY, tickDelta);
        if (this.prefix != null) {
            this.drawPrefix(graphicsHolder);
        }
        this.drawUpDownButton(graphicsHolder);
    }

    protected void drawPrefix(GraphicsHolder graphicsHolder) {
        int prefixWidth = GraphicsHolder.getTextWidth((String)this.prefix);
        int prefixX = this.getX2() - prefixWidth;
        int prefixY = this.getY2() + this.getHeight2() / 2 - 4;
        graphicsHolder.drawText(this.prefix, prefixX, prefixY, -1, true, 0xF000F0);
    }

    protected void drawUpDownButton(GraphicsHolder graphicsHolder) {
        MutableText upArrow = TextUtil.translatable(TextCategory.GUI, "widget.numeric_text_field.increment", new Object[0]);
        MutableText dnArrow = TextUtil.translatable(TextCategory.GUI, "widget.numeric_text_field.decrement", new Object[0]);
        int fontHeight = 9;
        int startY = this.field_22759 - fontHeight * 2;
        int upWidth = GraphicsHolder.getTextWidth((MutableText)upArrow);
        int dnWidth = GraphicsHolder.getTextWidth((MutableText)dnArrow);
        graphicsHolder.drawText(upArrow, this.getX2() + this.field_22758 - upWidth - 2, this.getY2() + startY, -1, false, 0xF000F0);
        graphicsHolder.drawText(dnArrow, this.getX2() + this.field_22758 - dnWidth - 2, this.getY2() + startY + fontHeight, -1, false, 0xF000F0);
    }

    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        if (this.field_22764 && this.field_22763 && this.isFocused2()) {
            if (amount > 0.0) {
                this.increment();
            } else {
                this.decrement();
            }
        }
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        MutableText upArrow = TextUtil.translatable(TextCategory.GUI, "widget.numeric_text_field.increment", new Object[0]);
        MutableText dnArrow = TextUtil.translatable(TextCategory.GUI, "widget.numeric_text_field.decrement", new Object[0]);
        int fontHeight = 9;
        int startY = this.getY2() + (this.field_22759 - fontHeight * 2) / 2;
        int upWidth = GraphicsHolder.getTextWidth((String)upArrow.getString());
        int dnWidth = GraphicsHolder.getTextWidth((String)dnArrow.getString());
        if (this.inRectangle(mouseX, mouseY, this.getX2() + this.field_22758 - upWidth - 2, startY, upWidth, fontHeight)) {
            this.increment();
        }
        if (this.inRectangle(mouseX, mouseY, this.getX2() + this.field_22758 - dnWidth - 2, startY + fontHeight, dnWidth, fontHeight)) {
            this.decrement();
        }
        return super.mouseClicked2(mouseX, mouseY, button);
    }

    public long getNumber() {
        try {
            return Integer.parseInt(this.getText2());
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }

    public void setValue(long value) {
        if (value < this.min || value > this.max) {
            return;
        }
        this.setText2(String.valueOf(value));
    }

    private void increment() {
        try {
            this.setValue(Integer.parseInt(this.getText2()) + 1);
        }
        catch (Exception e) {
            this.setValue(this.defaultValue);
        }
    }

    private void decrement() {
        try {
            this.setValue(Integer.parseInt(this.getText2()) - 1);
        }
        catch (Exception e) {
            this.setValue(this.defaultValue);
        }
    }
}

