/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render.gui.widget;

import fabric.com.lx862.jcm.mod.render.RenderHelper;
import fabric.com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import fabric.com.lx862.jcm.mod.render.gui.widget.WidgetsWrapper;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.ClickableWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;

public class WidgetSet
extends ClickableWidgetExtension
implements WidgetsWrapper,
RenderHelper {
    private final List<List<MappedWidget>> widgetRows = new ArrayList<List<MappedWidget>>();
    private final int maxWidgetHeight;
    public final int widgetXMargin;

    public WidgetSet(int maxWidgetHeight, int widgetXMargin) {
        super(0, 0, 0, 0);
        this.maxWidgetHeight = maxWidgetHeight;
        this.widgetXMargin = widgetXMargin;
    }

    public WidgetSet(int maxWidgetHeight) {
        this(maxWidgetHeight, 10);
    }

    public void setXYSize(int x, int y, int width, int height) {
        this.setX2(x);
        this.setY2(y);
        this.setWidth2(width);
        this.setHeightMapped(height);
        this.positionWidgets();
    }

    public void addWidget(ButtonWidgetExtension widget) {
        this.addWidget(new MappedWidget(widget));
    }

    public void addWidget(MappedWidget widget) {
        if (this.widgetRows.isEmpty()) {
            this.insertRow();
        }
        int lastRowIndex = this.widgetRows.size() - 1;
        List<MappedWidget> lastRow = this.widgetRows.get(lastRowIndex);
        lastRow.add(widget);
        this.widgetRows.set(lastRowIndex, lastRow);
    }

    public void insertRow() {
        this.widgetRows.add(new ArrayList());
    }

    public void reset() {
        this.widgetRows.clear();
    }

    private void positionWidgets() {
        int x = this.getX2();
        int y = this.getY2();
        int width = this.getWidth2() + this.widgetXMargin;
        int widgetHeight = Math.min(this.maxWidgetHeight, (int)((double)this.maxWidgetHeight * ((double)this.getHeight2() / (double)(this.widgetRows.size() * this.maxWidgetHeight))));
        for (int i = 0; i < this.widgetRows.size(); ++i) {
            List<MappedWidget> rowWidgets = this.widgetRows.get(i);
            double perWidgetWidth = (double)width / (double)rowWidgets.size() - (double)this.widgetXMargin;
            int rowY = y + i * widgetHeight;
            for (int j = 0; j < rowWidgets.size(); ++j) {
                MappedWidget widget = new MappedWidget(rowWidgets.get(j));
                double widgetStartX = (double)x + (double)j * perWidgetWidth + (double)(j * this.widgetXMargin);
                widget.setX((int)Math.round(widgetStartX));
                widget.setY(rowY);
                widget.setWidth((int)Math.round(perWidgetWidth));
            }
        }
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        for (List<MappedWidget> row : this.widgetRows) {
            for (MappedWidget widget : row) {
                widget.render(graphicsHolder, mouseX, mouseY, delta);
            }
        }
    }

    @Override
    public void setAllX(int newX) {
        super.setX2(newX);
        this.positionWidgets();
    }

    @Override
    public void setAllY(int newY) {
        super.setY2(newY);
        this.positionWidgets();
    }

    public void setVisibleMapped(boolean visible) {
        for (List<MappedWidget> row : this.widgetRows) {
            for (MappedWidget widget : row) {
                widget.setVisible(visible);
            }
        }
        super.setVisibleMapped(visible);
    }
}

