/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.render.text;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.lx862.jcm.mod.render.GuiHelper;
import fabric.com.lx862.jcm.mod.render.RenderHelper;
import fabric.com.lx862.jcm.mod.render.text.MCTextHelper;
import fabric.com.lx862.jcm.mod.render.text.TextInfo;
import fabric.com.lx862.jcm.mod.render.text.TextSlot;
import fabric.com.lx862.jcm.mod.render.text.font.FontSet;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.List;
import java.util.stream.Collectors;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageBackedTexture;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.InitClient;

public class TextureTextRenderer
implements RenderHelper {
    private static final int DEFAULT_ATLAS_WIDTH = 1024;
    private static final int DEFAULT_ATLAS_HEIGHT = 1024;
    private static final int MAX_ATLAS_SIZE = RenderSystem.maxSupportedTextureSize();
    private static final ObjectList<TextSlot> textSlots = new ObjectArrayList();
    private static NativeImageBackedTexture nativeImageBackedTexture = null;
    private static BufferedImage bufferedImageForTextGen = null;
    public static final int RENDERED_TEXT_SIZE = 9;
    public static final double MARQUEE_SPACING_RATIO = 0.8;
    public static final int FONT_RESOLUTION = 64;
    private static Identifier textAtlas = null;
    private static int width;
    private static int height;
    private static boolean initialized;

    public static void initialize() {
        if (initialized) {
            TextureTextRenderer.close();
        }
        JCMLogger.debug("Initializing TextureTextRenderer", new Object[0]);
        TextureTextRenderer.initTextureAtlas(1024, 1024);
        initialized = true;
    }

    public static void close() {
        if (!initialized) {
            throw new IllegalStateException("TextureTextRenderer already closed!");
        }
        nativeImageBackedTexture.close();
        nativeImageBackedTexture = null;
        bufferedImageForTextGen.flush();
        bufferedImageForTextGen = null;
        textSlots.clear();
        initialized = false;
    }

    private static void ensureInitialized() {
        if (!initialized) {
            TextureTextRenderer.initialize();
        }
    }

    public static boolean initialized() {
        return initialized;
    }

    private static void initTextureAtlas(int width, int height) {
        textSlots.clear();
        TextureTextRenderer.width = width;
        TextureTextRenderer.height = height;
        NativeImage nativeImage = new NativeImage(width, height, false);
        nativeImage.fillRect(0, 0, width, height, -16776961);
        if (bufferedImageForTextGen != null) {
            bufferedImageForTextGen.getGraphics().dispose();
        }
        if (nativeImageBackedTexture != null) {
            nativeImageBackedTexture.close();
        }
        nativeImageBackedTexture = new NativeImageBackedTexture(nativeImage);
        bufferedImageForTextGen = new BufferedImage(width, 128, 2);
        if (textAtlas != null) {
            MinecraftClient.getInstance().getTextureManager().destroyTexture(textAtlas);
        }
        textAtlas = MinecraftClient.getInstance().getTextureManager().registerDynamicTexture("jcm_atlas_text", nativeImageBackedTexture);
        for (int i = 0; i < height / 64; ++i) {
            int startX = 0;
            int startY = i * 64;
            textSlots.add((Object)new TextSlot(startX, startY));
        }
    }

    public static int getAtlasWidth() {
        return initialized ? width : -1;
    }

    public static int getAtlasHeight() {
        return initialized ? height : -1;
    }

    public static void bindTexture(GraphicsHolder graphicsHolder) {
        TextureTextRenderer.ensureInitialized();
        graphicsHolder.createVertexConsumer(RenderLayer.getBeaconBeam((Identifier)TextureTextRenderer.getAtlasIdentifier(), (boolean)true));
    }

    public static void addText(TextInfo text) {
        TextureTextRenderer.ensureInitialized();
        if (TextureTextRenderer.getTextSlot(text) == null) {
            FontSet fontSet = text.getFontSet();
            Graphics2D graphics = bufferedImageForTextGen.createGraphics();
            graphics.setComposite(AlphaComposite.SrcOver);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            AffineTransform affineTransform = new AffineTransform();
            AttributedString attributedString = TextureTextRenderer.getFormattedString(text, fontSet);
            Rectangle2D fullTextBound = TextureTextRenderer.getTextBound(attributedString);
            if (text.isForScrollingText()) {
                affineTransform.scale((double)width / fullTextBound.getWidth() * 0.8, 1.0);
            } else if (fullTextBound.getWidth() > (double)width) {
                affineTransform.scale((double)width / fullTextBound.getWidth(), 1.0);
            }
            graphics.setTransform(affineTransform);
            GlyphVector gv = fontSet.getTallestGlyphVector(attributedString.getIterator(), graphics.getFontRenderContext(), 64);
            Rectangle bound = gv.getOutline().getBounds();
            graphics.drawString(attributedString.getIterator(), 0, (int)((RectangularShape)bound).getHeight());
            TextureTextRenderer.drawOnFreeSlot(bufferedImageForTextGen, graphics, text);
            graphics.setComposite(AlphaComposite.Clear);
            graphics.fillRect(0, 0, width, bufferedImageForTextGen.getHeight());
            graphics.setComposite(AlphaComposite.SrcOver);
        }
    }

    private static AttributedString getFormattedString(TextInfo text, FontSet fontSet) {
        String filteredString = MCTextHelper.removeColorCode(text.getContent());
        Int2IntArrayMap mcColorCodeMap = MCTextHelper.getColorCodeMap(text);
        AttributedString attributedString = new AttributedString(filteredString);
        if (filteredString.isEmpty()) {
            return attributedString;
        }
        Font primaryFont = fontSet.getPrimaryFont(64);
        attributedString.addAttribute(TextAttribute.FONT, primaryFont);
        attributedString.addAttribute(TextAttribute.FOREGROUND, text.getTextColor());
        int currentTextColor = text.getTextColor();
        attributedString = fontSet.getAttributedString(filteredString, attributedString, 64);
        for (int i = 0; i < filteredString.length(); ++i) {
            if (mcColorCodeMap.containsKey(i)) {
                currentTextColor = mcColorCodeMap.get(i);
            }
            if (currentTextColor == -1) continue;
            attributedString.addAttribute(TextAttribute.FOREGROUND, new Color(currentTextColor), i, i + 1);
        }
        return attributedString;
    }

    private static void drawOnFreeSlot(BufferedImage bufferedImage, Graphics2D graphics, TextInfo text) {
        TextureTextRenderer.ensureInitialized();
        boolean allUsedUp = textSlots.stream().noneMatch(TextSlot::unused);
        List availableSlots = textSlots.stream().filter(e -> allUsedUp ? e.reusable() : e.unused()).sorted().collect(Collectors.toList());
        if (availableSlots.isEmpty()) {
            if (height + 1024 <= MAX_ATLAS_SIZE) {
                JCMLogger.debug("[TextureTextRenderer] No space left to draw text, resizing to a bigger atlas!", new Object[0]);
                TextureTextRenderer.initTextureAtlas(width, Math.min(height + 1024, MAX_ATLAS_SIZE));
            } else {
                JCMLogger.debug("[TextureTextRenderer] No space left to draw text, cannot resize beyond " + MAX_ATLAS_SIZE + "!", new Object[0]);
            }
            return;
        }
        TextSlot firstAvailableSlot = (TextSlot)availableSlots.get(0);
        Rectangle2D textBound = TextureTextRenderer.getTextBound(text, graphics.getTransform());
        int textWidth = (int)Math.ceil(textBound.getWidth());
        int textHeight = (int)Math.ceil(textBound.getHeight());
        if (text.isForScrollingText()) {
            textWidth = width;
        }
        firstAvailableSlot.setContent(text, textWidth, 64);
        TextureTextRenderer.drawToNativeImage(bufferedImage, firstAvailableSlot.getStartX(), firstAvailableSlot.getStartY(), firstAvailableSlot.getPixelWidth(), 64);
    }

    private static void drawToNativeImage(BufferedImage bufferedImage, int x, int y, int width, int height) {
        for (int w = 0; w < width; ++w) {
            for (int h = 0; h < height; ++h) {
                if (w >= TextureTextRenderer.width || h >= TextureTextRenderer.height) continue;
                nativeImageBackedTexture.getImage().setPixelColor(x + w, y + h, TextureTextRenderer.toAbgr(bufferedImage.getRGB(w, h)));
            }
        }
        if (nativeImageBackedTexture.getImage() != null) {
            nativeImageBackedTexture.bindTexture();
            nativeImageBackedTexture.getImage().upload(0, x, y, x, y, width, height, false, false, false, false);
        }
    }

    public static int toAbgr(int rgb) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static TextSlot getTextSlot(TextInfo textInfo) {
        for (TextSlot textSlot : textSlots) {
            if (!textSlot.isHoldingText(textInfo)) continue;
            return textSlot;
        }
        return null;
    }

    public static void draw(GraphicsHolder graphicsHolder, TextInfo text, Direction facing, double x, double y) {
        TextureTextRenderer.ensureInitialized();
        TextSlot textSlot = TextureTextRenderer.getTextSlot(text);
        if (textSlot == null) {
            TextureTextRenderer.addText(text);
            textSlot = TextureTextRenderer.getTextSlot(text);
        }
        if (textSlot != null) {
            float finalX = (float)text.getTextAlignment().getX(x, textSlot.getRenderedWidth());
            TextureTextRenderer.drawToWorld(graphicsHolder, textSlot, facing, finalX, (float)y);
        }
    }

    public static void draw(GuiDrawing guiDrawing, TextInfo text, double x, double y) {
        TextureTextRenderer.ensureInitialized();
        TextSlot textSlot = TextureTextRenderer.getTextSlot(text);
        if (textSlot == null) {
            TextureTextRenderer.addText(text);
            textSlot = TextureTextRenderer.getTextSlot(text);
        }
        if (textSlot != null) {
            float finalX = (float)text.getTextAlignment().getX(x, textSlot.getRenderedWidth());
            TextureTextRenderer.draw(guiDrawing, textSlot, finalX, (float)y);
        }
    }

    private static void draw(GuiDrawing guiDrawing, TextSlot textSlot, float x, float y) {
        TextureTextRenderer.ensureInitialized();
        textSlot.accessedNow();
        float startY = textSlot.getStartY();
        float onePart = (float)textSlot.getHeight() / (float)height;
        float u1 = 0.0f;
        float u2 = (float)textSlot.getPixelWidth() / (float)width;
        float v1 = startY / (float)height;
        float v2 = v1 + onePart;
        if (textSlot.getText().isForScrollingText()) {
            float ratio = textSlot.getMaxWidth() / (float)textSlot.getPhysicalWidth();
            u2 *= ratio;
            u1 += InitClient.getGameTick() % 100.0f / 100.0f;
            u2 += InitClient.getGameTick() % 100.0f / 100.0f;
        }
        GuiHelper.drawTexture(guiDrawing, TextureTextRenderer.getAtlasIdentifier(), x, y, (int)textSlot.getRenderedWidth(), 9.0, u1, v1, u2, v2);
    }

    private static void drawToWorld(GraphicsHolder graphicsHolder, TextSlot textSlot, Direction facing, float x, float y) {
        TextureTextRenderer.ensureInitialized();
        textSlot.accessedNow();
        float startY = textSlot.getStartY();
        float onePart = (float)textSlot.getHeight() / (float)height;
        float u1 = 0.0f;
        float u2 = (float)textSlot.getPixelWidth() / (float)width;
        float v1 = startY / (float)height;
        float v2 = v1 + onePart;
        if (textSlot.getText().isForScrollingText()) {
            float ratio = textSlot.getMaxWidth() / (float)textSlot.getPhysicalWidth();
            u2 *= ratio;
            u1 += InitClient.getGameTick() % 100.0f / 100.0f;
            u2 += InitClient.getGameTick() % 100.0f / 100.0f;
        }
        RenderHelper.drawTexture(graphicsHolder, x, y - 0.75f, 0.0f, (int)textSlot.getRenderedWidth(), 9.0f, u1, v1, u2, v2, facing, -1, 0xF000F0);
    }

    public static void stressTest(int updateFrequency) {
        if (InitClient.getGameTick() % (float)updateFrequency == 0.0f) {
            String[] strArr = new String[]{"Central", "610 Tuen Mun Ferry Pier", "Admiralty", "Kennedy Town", "Minecraft!", "$050302", "33:44", "October", "November", "December", "3 min", "^_^", "Fabric modloader", "Joban Client Mod", "Minecraft Transit Railway 3", "Text Renderer", "Block Entity", "SIGKILL", "Lorem ipsum", "Minceraft", "JCM", "Minecraft Transit Railway 4", "Text Rendering", "Block Entity Renderer", "main", "Fish.", "The quick brown fox jumps over the lazy dog", "woem!", "git", "Stress Test In Progress", "[07L]"};
            double colorRand = Math.random();
            String text = strArr[(int)(Math.random() * (double)strArr.length)];
            if (colorRand > 0.5) {
                TextureTextRenderer.addText(new TextInfo(text).withColor(-16777216));
            } else {
                TextureTextRenderer.addText(new TextInfo(text).withColor(-1));
            }
        }
    }

    public static Rectangle2D getTextBound(TextInfo textInfo) {
        return TextureTextRenderer.getTextBound(textInfo, new AffineTransform());
    }

    public static Rectangle2D getTextBound(TextInfo textInfo, AffineTransform affineTransform) {
        AttributedString attributedString = TextureTextRenderer.getFormattedString(textInfo, textInfo.getFontSet());
        return TextureTextRenderer.getTextBound(attributedString, affineTransform);
    }

    public static Rectangle2D getTextBound(AttributedString attributedString) {
        return TextureTextRenderer.getTextBound(attributedString, new AffineTransform());
    }

    public static Rectangle2D getTextBound(AttributedString attributedString, AffineTransform affineTransform) {
        if (attributedString.getIterator().getBeginIndex() == attributedString.getIterator().getEndIndex()) {
            return new Rectangle();
        }
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        return new Rectangle((int)textLayout.getBounds().getX(), (int)textLayout.getBounds().getY(), (int)((double)textLayout.getAdvance() * affineTransform.getScaleX()), (int)(textLayout.getBounds().getHeight() * affineTransform.getScaleY()));
    }

    public static int getPhysicalWidth(TextInfo textInfo) {
        double pixelWidth = Math.min(1024.0, TextureTextRenderer.getTextBound(textInfo).getWidth());
        double physicalWidth = pixelWidth / 64.0 * 9.0;
        return (int)textInfo.getWidthInfo().clampWidth(physicalWidth);
    }

    public static Identifier getAtlasIdentifier() {
        return textAtlas;
    }
}

