/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.resources;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fabric.com.lx862.jcm.mod.Constants;
import fabric.com.lx862.jcm.mod.JCMClient;
import fabric.com.lx862.jcm.mod.data.pids.PIDSManager;
import fabric.com.lx862.jcm.mod.render.text.TextRenderingManager;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class JCMResourceManager {
    private static final Identifier CUSTOM_RESOURCE_PATH = Constants.id("joban_custom_resources.json");

    public static void reload() {
        JCMClient.getMcMetaManager().reset();
        TextRenderingManager.initialize();
        PIDSManager.reset();
        JCMResourceManager.parseCustomResources();
    }

    private static void parseCustomResources() {
        ResourceManagerHelper.readAllResources((Identifier)CUSTOM_RESOURCE_PATH, inputStream -> {
            try {
                String str = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
                JsonObject jsonObject = new JsonParser().parse(str).getAsJsonObject();
                PIDSManager.loadJson(jsonObject);
            }
            catch (Exception e) {
                JCMLogger.error("Failed to parse custom resource file!", e);
            }
        });
    }
}

