/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.resources.mcmeta;

import com.google.gson.JsonParser;
import fabric.com.lx862.jcm.mod.data.Pair;
import fabric.com.lx862.jcm.mod.resources.mcmeta.McMeta;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class McMetaManager {
    private final HashMap<Identifier, McMeta> mcMetaList = new HashMap();

    public void reset() {
        this.mcMetaList.clear();
    }

    public void load(Identifier imagePath) {
        if (this.mcMetaList.containsKey(imagePath)) {
            return;
        }
        Identifier mcmetaFile = new Identifier(imagePath.getNamespace(), imagePath.getPath() + ".mcmeta");
        String str = ResourceManagerHelper.readResource((Identifier)mcmetaFile);
        if (!str.isEmpty()) {
            JCMLogger.debug("[McMetaManager] Loading mcmeta file: " + imagePath.getPath(), new Object[0]);
            try {
                McMeta mcMeta = McMeta.parse(new JsonParser().parse(str).getAsJsonObject());
                McMetaManager.readImage(mcMeta, imagePath, mcMeta1 -> this.mcMetaList.put(imagePath, (McMeta)mcMeta1));
            }
            catch (Exception e) {
                JCMLogger.error("[McMetaManager] Failed to read mcmeta file {}!", imagePath.toString(), e);
            }
        }
    }

    public void tick() {
        for (McMeta mcMeta : this.mcMetaList.values()) {
            mcMeta.tick();
        }
    }

    public Pair<Float, Float> getUV(Identifier id) {
        if (!this.mcMetaList.containsKey(id)) {
            return new Pair<Float, Float>(Float.valueOf(0.0f), Float.valueOf(1.0f));
        }
        return this.mcMetaList.get(id).getUV();
    }

    private static void readImage(McMeta mcMeta, Identifier imageFile, Consumer<McMeta> callback) {
        ResourceManagerHelper.readResource((Identifier)imageFile, inputStream -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                int width = bufferedImage.getWidth();
                int height = bufferedImage.getHeight();
                JCMLogger.debug("[McMetaManager] Loaded mcmeta image metadata: {} ({})", imageFile.getPath(), width + "x" + height);
                mcMeta.setVerticalPart(height / width);
                callback.accept(mcMeta);
            }
            catch (IOException e) {
                JCMLogger.error("[McMetaManager] Failed to read image metadata from {}!", imageFile.getPath());
            }
        });
    }
}

