/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.lx862.jcm.mod.scripting.mtr.vehicle;

import com.lx862.mtrscripting.core.ScriptContext;
import com.lx862.mtrscripting.util.Matrices;
import com.lx862.mtrscripting.util.ScriptedModel;
import fabric.com.lx862.jcm.mod.scripting.mtr.sound.NonPositionedSoundCall;
import fabric.com.lx862.jcm.mod.scripting.mtr.sound.PositionedSoundCall;
import fabric.com.lx862.jcm.mod.scripting.mtr.sound.SoundCall;
import fabric.com.lx862.jcm.mod.scripting.mtr.vehicle.VehicleModelDrawCall;
import fabric.com.lx862.jcm.mod.scripting.mtr.vehicle.VehicleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.mtr.mapping.holder.Identifier;

public class VehicleScriptContext
extends ScriptContext {
    private final List<VehicleModelDrawCall> carModelDrawCalls = new ArrayList<VehicleModelDrawCall>();
    private final List<VehicleModelDrawCall> conectionModelDrawCalls = new ArrayList<VehicleModelDrawCall>();
    private final List<SoundCall> carSoundCalls = new ArrayList<SoundCall>();
    private final List<SoundCall> announceSoundCalls = new ArrayList<SoundCall>();
    private final String vehicleId;

    @Override
    public void reset() {
        this.carModelDrawCalls.clear();
        this.conectionModelDrawCalls.clear();
        this.carSoundCalls.clear();
        this.announceSoundCalls.clear();
    }

    public VehicleScriptContext(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public void drawCarModel(ScriptedModel model, int carIndex, Matrices matrices) {
        this.carModelDrawCalls.add(new VehicleModelDrawCall(model, carIndex, matrices == null ? null : matrices.getStoredMatrixTransformations().copy()));
    }

    public void drawConnModel(ScriptedModel model, int carIndex, Matrices matrices) {
        this.conectionModelDrawCalls.add(new VehicleModelDrawCall(model, carIndex, matrices == null ? null : matrices.getStoredMatrixTransformations().copy()));
    }

    public void playCarSound(Identifier sound, int carIndex, float x, float y, float z, float volume, float pitch) {
        this.carSoundCalls.add(new PositionedSoundCall(sound, x, y, z, volume, pitch));
        throw new NotImplementedException("Not implemented");
    }

    public void playAnnSound(Identifier sound, float volume, float pitch) {
        this.announceSoundCalls.add(new NonPositionedSoundCall(sound, volume, pitch));
    }

    public boolean isMyVehicle(VehicleWrapper vehicleWrapper, int carIndex) {
        String theirVehicleId = vehicleWrapper.trainTypeId(carIndex);
        return Objects.equals(this.vehicleId, theirVehicleId);
    }

    public List<VehicleModelDrawCall> getCarModelDrawCalls() {
        return new ArrayList<VehicleModelDrawCall>(this.carModelDrawCalls);
    }

    public List<VehicleModelDrawCall> getConnectionModelDrawCalls() {
        return new ArrayList<VehicleModelDrawCall>(this.conectionModelDrawCalls);
    }

    public List<SoundCall> getCarSoundCalls() {
        return new ArrayList<SoundCall>(this.carSoundCalls);
    }

    public List<SoundCall> getAnnounceSoundCalls() {
        return new ArrayList<SoundCall>(this.announceSoundCalls);
    }
}

