/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.block;

import forge.com.lx862.jcm.mod.block.base.Vertical2Block;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemConvertible;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.Items;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvents;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public class WaterMachineBlock
extends Vertical2Block {
    public WaterMachineBlock(BlockSettings settings) {
        super(settings);
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)16.0, (double)13.5, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (player.isHolding(Items.getGlassBottleMapped())) {
            WaterMachineBlock.fillBottleForPlayer(player, hand);
            return ActionResult.SUCCESS;
        }
        if (player.isHolding(Items.getBucketMapped())) {
            WaterMachineBlock.fillBucketForPlayer(player, hand);
            return ActionResult.SUCCESS;
        }
        return ActionResult.FAIL;
    }

    private static void fillBottleForPlayer(PlayerEntity player, Hand hand) {
        ItemStack newWaterBottle = new ItemStack(ItemConvertible.cast((HolderBase)Items.getPotionMapped()));
        newWaterBottle.getOrCreateTag().putString("Potion", "water");
        WaterMachineBlock.offerOrDrop(player, hand, newWaterBottle);
        WaterMachineBlock.playSplashSoundToPlayer(player);
    }

    private static void fillBucketForPlayer(PlayerEntity player, Hand hand) {
        ItemStack newWaterBucket = new ItemStack(ItemConvertible.cast((HolderBase)Items.getWaterBucketMapped()));
        WaterMachineBlock.offerOrDrop(player, hand, newWaterBucket);
        WaterMachineBlock.playSplashSoundToPlayer(player);
    }

    private static void offerOrDrop(PlayerEntity player, Hand hand, ItemStack stack) {
        ItemStack playerHolding = player.getStackInHand(hand);
        playerHolding.decrement(1);
        if (playerHolding.isEmpty()) {
            player.setStackInHand(hand, stack);
        } else {
            PlayerHelper.getPlayerInventory((PlayerEntity)player).insertStack(stack);
        }
    }

    private static void playSplashSoundToPlayer(PlayerEntity player) {
        player.playSound(SoundEvents.getItemBucketFillMapped(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

