/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.block.base;

import forge.com.lx862.jcm.mod.block.base.DirectionalBlock;
import forge.com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mod.block.IBlock;

public abstract class Horizontal2MirroredBlock
extends DirectionalBlock {
    public Horizontal2MirroredBlock(BlockSettings settings) {
        super(settings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction placeDirection = ctx.getPlayerFacing().getOpposite();
        return BlockUtil.isReplacable(ctx.getWorld(), ctx.getBlockPos(), placeDirection, ctx, 2) && super.getPlacementState2(ctx) != null ? super.getPlacementState2(ctx).with(new Property((net.minecraft.world.level.block.state.properties.Property)Horizontal2MirroredBlock.FACING.data), (Comparable)placeDirection.data) : null;
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (world.isClient()) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        world.setBlockState(pos.offset(facing), state.with(new Property((net.minecraft.world.level.block.state.properties.Property)Horizontal2MirroredBlock.FACING.data), (Comparable)facing.getOpposite().data), 3);
    }

    public void onBreak2(World world, BlockPos breakPos, BlockState breakState, PlayerEntity player) {
        this.breakWithoutDropIfCreative(world, breakPos, breakState, player, this, this::getLootDropPos);
        super.onBreak2(world, breakPos, breakState, player);
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING) == direction && !neighborState.isOf(new Block((net.minecraft.world.level.block.Block)this))) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    @Override
    public BlockPos[] getAllPos(BlockState state, WorldAccess world, BlockPos pos) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos otherPos = pos.offset(facing);
        return new BlockPos[]{pos, otherPos};
    }

    public BlockPos getLootDropPos(BlockState state, BlockPos pos) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (facing == Direction.EAST || facing == Direction.NORTH) {
            return pos;
        }
        return pos.offset(facing);
    }
}

