/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.com.lx862.jcm.mod.util.JCMLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;

public abstract class Config {
    private final Path configPath;

    public Config(Path configPath) {
        this.configPath = configPath;
    }

    public void read() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.write();
            this.read();
        } else {
            try {
                JsonObject jsonObject = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(this.configPath))).getAsJsonObject();
                this.fromJson(jsonObject);
            }
            catch (Exception e) {
                JCMLogger.error("Error reading the config file: ", e);
                this.write();
                JCMLogger.warn("Failed to read config file, config may be left at it's default state.", new Object[0]);
            }
        }
    }

    public void write() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.write(this.configPath, Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.toJson())), new OpenOption[0]);
        }
        catch (IOException e) {
            JCMLogger.error("", e);
        }
    }

    public final void reset() {
        this.fromJson(new JsonObject());
        this.write();
    }

    protected abstract void fromJson(JsonObject var1);

    protected abstract JsonObject toJson();
}

