/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.data.pids;

import com.google.gson.JsonObject;
import forge.com.lx862.jcm.mod.data.pids.preset.JsonPIDSPreset;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import forge.com.lx862.jcm.mod.data.pids.preset.ScriptPIDSPreset;
import forge.com.lx862.jcm.mod.util.JCMLogger;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.stream.Collectors;

public class PIDSManager {
    private static final Object2ObjectArrayMap<String, PIDSPresetBase> presetList = new Object2ObjectArrayMap();

    public static void loadJson(JsonObject customResourceJson) {
        customResourceJson.get("pids_images").getAsJsonArray().forEach(e -> {
            String presetId = "(Unknown preset)";
            try {
                JsonObject jsonObject = e.getAsJsonObject();
                presetId = jsonObject.get("id").getAsString();
                PIDSPresetBase preset = jsonObject.has("scriptFiles") || jsonObject.has("scriptTexts") ? ScriptPIDSPreset.parse(jsonObject) : JsonPIDSPreset.parse(e.getAsJsonObject());
                if (presetList.containsKey((Object)preset.getId()) && !preset.builtin) {
                    JCMLogger.error("Custom preset \"{}\" already added!", presetId);
                } else {
                    presetList.put((Object)preset.getId(), (Object)preset);
                }
            }
            catch (Exception ex) {
                JCMLogger.error("Failed to parse PIDS Preset \"" + presetId + "\"!", ex);
            }
        });
    }

    public static PIDSPresetBase getPreset(String id, PIDSPresetBase defaultPreset) {
        return (PIDSPresetBase)presetList.getOrDefault((Object)id, (Object)defaultPreset);
    }

    public static PIDSPresetBase getPreset(String id) {
        return PIDSManager.getPreset(id, null);
    }

    public static List<PIDSPresetBase> getBuiltInPresets() {
        return presetList.values().stream().filter(e -> e.builtin).collect(Collectors.toList());
    }

    public static List<PIDSPresetBase> getCustomPresets() {
        return presetList.values().stream().filter(e -> !e.builtin).collect(Collectors.toList());
    }

    public static void reset() {
        presetList.entrySet().removeIf(e -> !((PIDSPresetBase)e.getValue()).builtin);
    }
}

