/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.data.pids.preset;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import forge.com.lx862.jcm.mod.JCMClient;
import forge.com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import forge.com.lx862.jcm.mod.data.KVPair;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalCarComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalDestinationComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalETAComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalTextureComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ClockComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.CustomTextComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.CycleComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.PlatformComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.WeatherIconComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import forge.com.lx862.jcm.mod.render.RenderHelper;
import forge.com.lx862.jcm.mod.render.text.TextAlignment;
import forge.com.lx862.jcm.mod.render.text.TextOverflowMode;
import forge.com.lx862.jcm.mod.render.text.TextTranslationMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.data.IGui;

public class JsonPIDSPreset
extends PIDSPresetBase {
    private static final int PIDS_MARGIN = 7;
    private static final float ARRIVAL_TEXT_SCALE = 1.225f;
    private static final int HEADER_HEIGHT = 9;
    private static final String ICON_WEATHER_SUNNY = "jsblock:textures/block/pids/weather_sunny.png";
    private static final String ICON_WEATHER_RAINY = "jsblock:textures/block/pids/weather_rainy.png";
    private static final String ICON_WEATHER_THUNDER = "jsblock:textures/block/pids/weather_thunder.png";
    private static final String TEXTURE_PLATFORM_CIRCLE = "jsblock:textures/block/pids/plat_circle.png";
    private final Identifier background;
    private final String fontId;
    private final TextOverflowMode textOverflowMode;
    private final boolean showClock;
    private final boolean showWeather;
    private final boolean topPadding;
    private final boolean hidePlatform;
    private final int textColor;
    private final boolean[] rowHidden;

    public JsonPIDSPreset(String id, @Nullable String name, Identifier thumbnail, List<String> blacklist, Identifier background, @Nullable String fontId, TextOverflowMode textOverflowMode, boolean[] rowHidden, boolean showClock, boolean showWeather, boolean topPadding, boolean builtin, boolean hidePlatform, int textColor) {
        super(id, name, thumbnail, blacklist, builtin);
        this.background = background;
        this.showClock = showClock;
        this.showWeather = showWeather;
        this.textColor = textColor;
        this.fontId = fontId == null ? "mtr:mtr" : fontId;
        this.rowHidden = rowHidden;
        this.topPadding = topPadding;
        this.textOverflowMode = textOverflowMode;
        this.hidePlatform = hidePlatform;
    }

    public static JsonPIDSPreset parse(JsonObject rootJsonObject) {
        int i;
        boolean[] rowHidden;
        JsonArray arr;
        int textColor;
        String id = rootJsonObject.get("id").getAsString();
        String name = rootJsonObject.has("name") ? rootJsonObject.get("name").getAsString() : id;
        Identifier background = rootJsonObject.has("background") ? new Identifier(rootJsonObject.get("background").getAsString()) : null;
        Identifier thumbnail = rootJsonObject.has("thumbnail") ? new Identifier(rootJsonObject.get("thumbnail").getAsString()) : background;
        String font = rootJsonObject.has("fonts") ? rootJsonObject.get("fonts").getAsString() : null;
        TextOverflowMode textOverflowMode = rootJsonObject.has("textOverflowMode") ? TextOverflowMode.valueOf(rootJsonObject.get("textOverflowMode").getAsString()) : TextOverflowMode.STRETCH;
        boolean builtin = rootJsonObject.has("builtin") && rootJsonObject.get("builtin").getAsBoolean();
        boolean showWeather = rootJsonObject.has("showWeather") && rootJsonObject.get("showWeather").getAsBoolean();
        boolean showClock = rootJsonObject.has("showClock") && rootJsonObject.get("showClock").getAsBoolean();
        boolean topPadding = !rootJsonObject.has("topPadding") ? true : rootJsonObject.get("topPadding").getAsBoolean();
        boolean hidePlatform = rootJsonObject.has("hidePlatform") && rootJsonObject.get("hidePlatform").getAsBoolean();
        int n = textColor = rootJsonObject.has("color") ? (int)Long.parseLong(rootJsonObject.get("color").getAsString(), 16) : -16777216;
        if (background == null) {
            throw new IllegalArgumentException("A JSON PIDS Preset must have background set!");
        }
        JCMClient.getMcMetaManager().load(background);
        ArrayList<String> blackList = new ArrayList<String>();
        if (rootJsonObject.has("hideRow")) {
            arr = rootJsonObject.getAsJsonArray("hideRow");
            rowHidden = new boolean[arr.size()];
            for (i = 0; i < arr.size(); ++i) {
                rowHidden[i] = arr.get(i).getAsBoolean();
            }
        } else {
            rowHidden = new boolean[]{};
        }
        if (rootJsonObject.has("blacklist")) {
            arr = rootJsonObject.getAsJsonArray("blacklist");
            for (i = 0; i < arr.size(); ++i) {
                blackList.add(arr.get(i).getAsString());
            }
        }
        return new JsonPIDSPreset(id, name, thumbnail, blackList, background, font, textOverflowMode, rowHidden, showClock, showWeather, topPadding, builtin, hidePlatform, textColor);
    }

    @Override
    public void render(PIDSBlockEntity be, GraphicsHolder graphicsHolder, World world, BlockPos pos, Direction facing, ObjectArrayList<ArrivalResponse> arrivals, boolean[] rowHidden, float tickDelta, int x, int y, int width, int height) {
        int headerHeight = this.topPadding ? 9 : 0;
        int startX = 7;
        int contentWidth = width - 14;
        int contentHeight = height - headerHeight - 3;
        graphicsHolder.createVertexConsumer(RenderLayer.getText((Identifier)this.background));
        RenderHelper.drawTexture(graphicsHolder, this.background, x, y, 0.0f, width, height, facing, -1, 0xF000F0);
        if (JCMClient.getConfig().debug) {
            this.drawAtlasBackground(graphicsHolder, width, height, facing);
        }
        graphicsHolder.translate((double)startX, 0.0, -0.05);
        List<PIDSComponent> components = this.getComponents(arrivals, be.getCustomMessages(), rowHidden, x, y, contentWidth, contentHeight, be.getRowAmount(), be.platformNumberHidden());
        PIDSContext pidsContext = new PIDSContext(world, pos, be.getCustomMessages(), arrivals, tickDelta);
        graphicsHolder.push();
        for (PIDSComponent component : components) {
            graphicsHolder.translate(0.0, 0.0, -0.02);
            graphicsHolder.push();
            component.render(graphicsHolder, null, facing, pidsContext);
            graphicsHolder.pop();
        }
        graphicsHolder.pop();
    }

    public List<PIDSComponent> getComponents(ObjectArrayList<ArrivalResponse> arrivals, String[] customMessages, boolean[] rowHidden, int x, int y, int screenWidth, int screenHeight, int rows, boolean hidePlatform) {
        ArrayList<PIDSComponent> components = new ArrayList<PIDSComponent>();
        if (this.showClock) {
            components.add(new ClockComponent(x + screenWidth, y + 2, screenWidth, 10.0, TextComponent.of(TextAlignment.RIGHT, TextOverflowMode.STRETCH, this.fontId, -1, 0.9)));
        }
        if (this.showWeather) {
            components.add(new WeatherIconComponent(x, y, 9.0, 9.0, new KVPair().with("weatherIconSunny", ICON_WEATHER_SUNNY).with("weatherIconRainy", ICON_WEATHER_RAINY).with("weatherIconThunder", ICON_WEATHER_THUNDER)));
        }
        boolean platformShown = !hidePlatform && !this.hidePlatform;
        boolean showCar = false;
        int tmpCar = -1;
        for (ArrivalResponse arrival : arrivals) {
            if (tmpCar == -1) {
                tmpCar = arrival.getCarCount();
                continue;
            }
            if (tmpCar == arrival.getCarCount()) continue;
            showCar = true;
        }
        int arrivalIndex = 0;
        double rowY = y + (this.topPadding ? 9 : 0) + 4;
        for (int i = 0; i < rows; ++i) {
            double totalWidth = screenWidth;
            totalWidth -= 7.0;
            totalWidth -= 7.0;
            totalWidth -= 36.75;
            if (platformShown) {
                totalWidth -= (double)17.15f;
            }
            if (customMessages[i] != null && !customMessages[i].isEmpty()) {
                components.add(new CustomTextComponent(x, rowY, screenWidth - 21, 10.0, TextComponent.of(TextAlignment.LEFT, this.textOverflowMode, this.fontId, this.getTextColor(), 1.225f).with("text", customMessages[i])));
            } else {
                if (arrivalIndex >= arrivals.size()) continue;
                if (!rowHidden[i]) {
                    ArrivalResponse thisArrival;
                    boolean destinationIsCjk;
                    ArrivalDestinationComponent arrivalDestinationComponent = new ArrivalDestinationComponent(x, rowY, totalWidth, 10.0, TextComponent.of(TextAlignment.LEFT, this.textOverflowMode, this.fontId, this.textColor, 1.225f).with("arrivalIndex", arrivalIndex));
                    components.add(arrivalDestinationComponent);
                    if (platformShown) {
                        components.add(new ArrivalTextureComponent((float)screenWidth - 49.0f, rowY, 10.0, 10.0, new KVPair().with("textureId", TEXTURE_PLATFORM_CIRCLE).with("arrivalIndex", arrivalIndex)));
                        components.add(new PlatformComponent((float)screenWidth - 49.0f, rowY, 8.0, 8.0, this.fontId, -1, 0.85, new KVPair().with("arrivalIndex", arrivalIndex)));
                    }
                    TextTranslationMode mode = (destinationIsCjk = IGui.isCjk((String)arrivalDestinationComponent.getDestinationString(thisArrival = (ArrivalResponse)arrivals.get(arrivalIndex)))) ? TextTranslationMode.CJK : TextTranslationMode.NON_CJK;
                    ArrivalETAComponent eta = new ArrivalETAComponent(screenWidth, rowY, 26.95f, 20.0, TextComponent.of(TextAlignment.RIGHT, TextOverflowMode.STRETCH, this.fontId, this.textColor, 1.225f).with("arrivalIndex", arrivalIndex).with("textTranslationMode", mode.name()));
                    ArrivalCarComponent car = new ArrivalCarComponent(screenWidth, rowY, 26.95f, 20.0, TextComponent.of(TextAlignment.RIGHT, TextOverflowMode.STRETCH, this.fontId, this.textColor, 1.225f).with("arrivalIndex", arrivalIndex).with("textTranslationMode", mode.name()));
                    if (showCar) {
                        components.add(new CycleComponent(new KVPair().with("cycleTime", 80), eta, car));
                    } else {
                        components.add(eta);
                    }
                    ++arrivalIndex;
                }
            }
            rowY += (double)screenHeight / 4.7 * (double)1.225f;
        }
        return components;
    }

    @Override
    public int getTextColor() {
        return 0xFF000000 | this.textColor;
    }

    @Override
    public boolean isRowHidden(int row) {
        return this.rowHidden.length - 1 < row ? false : this.rowHidden[row];
    }
}

