/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.data.pids.preset.components;

import com.google.gson.JsonObject;
import forge.com.lx862.jcm.mod.data.KVPair;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import forge.com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import net.minecraft.world.level.Level;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.WorldHelper;

public class CustomTextComponent
extends TextComponent {
    private final String text;

    public CustomTextComponent(double x, double y, double width, double height, KVPair addtionalParam) {
        super(x, y, width, height, addtionalParam);
        this.text = addtionalParam.get("text", "");
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, PIDSContext context) {
        this.drawText(graphicsHolder, guiDrawing, facing, CustomTextComponent.parsePIDSVariable(this.text, context));
    }

    @Override
    public boolean canRender(PIDSContext context) {
        return !this.text.isEmpty();
    }

    public static PIDSComponent parseComponent(double x, double y, double width, double height, JsonObject jsonObject) {
        return new CustomTextComponent(x, y, width, height, new KVPair(jsonObject));
    }

    private static String parsePIDSVariable(String str, PIDSContext context) {
        String weatherString;
        long time = WorldHelper.getTimeOfDay((World)context.world) + 6000L;
        long hours = time / 1000L;
        long minutes = Math.round((double)(time - hours * 1000L) / 16.8);
        String timeString = String.format("%02d:%02d", hours % 24L, minutes % 60L);
        String string = context.world.isRaining() ? "Raining" : (weatherString = context.world.isThundering() ? "Thundering" : "Sunny");
        String weatherChinString = context.world.isRaining() ? "\u4e0b\u96e8" : (context.world.isThundering() ? "\u96f7\u66b4" : "\u6674\u5929");
        int worldDay = (int)(WorldHelper.getTimeOfDay((World)context.world) / 24000L);
        String timeGreetings = time >= 6000L & time <= 12000L ? "Morning" : (time >= 12000L & time <= 18000L ? "Afternoon" : "Night");
        int playerInWorld = ((Level)context.world.data).m_6907_().size();
        return str.replace("{time}", timeString).replace("{day}", String.valueOf(worldDay)).replace("{weather}", weatherString).replace("{time_period}", timeGreetings).replace("{weatherChin}", weatherChinString).replace("{worldPlayer}", String.valueOf(playerInWorld));
    }
}

