/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.data.pids.preset.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import forge.com.lx862.jcm.mod.data.KVPair;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import forge.com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.InitClient;

public class CycleComponent
extends PIDSComponent {
    private final List<PIDSComponent> components;
    private final double cycleTime;

    public CycleComponent(KVPair additionalParam, PIDSComponent ... components) {
        super(0.0, 0.0, 0.0, 0.0);
        this.cycleTime = additionalParam.getInt("cycleTime", 20);
        this.components = new ArrayList<PIDSComponent>();
        JsonArray array = additionalParam.get("components", new JsonArray());
        for (int i = 0; i < array.size(); ++i) {
            this.components.add(PIDSComponent.parse(array.get(i).getAsJsonObject()));
        }
        this.components.addAll(Arrays.asList(components));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, PIDSContext context) {
        if (this.components.isEmpty()) {
            return;
        }
        List filteredComponents = this.components.stream().filter(e -> e.canRender(context)).collect(Collectors.toList());
        if (this.cycleTime == -1.0 && !filteredComponents.isEmpty()) {
            ((PIDSComponent)filteredComponents.get(0)).render(graphicsHolder, guiDrawing, facing, context);
        } else {
            int currentComponentIndex = (int)((double)((int)((double)InitClient.getGameTick() % (this.cycleTime * (double)filteredComponents.size()))) / this.cycleTime);
            PIDSComponent component = (PIDSComponent)filteredComponents.get(currentComponentIndex);
            component.render(graphicsHolder, guiDrawing, facing, context);
        }
    }

    public static PIDSComponent parseComponent(double x, double y, double width, double height, JsonObject jsonObject) {
        return new CycleComponent(new KVPair(jsonObject), new PIDSComponent[0]);
    }
}

