/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.data.pids.preset.components.base;

import com.google.gson.JsonObject;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalCarComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalDestinationComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ArrivalETAComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.ClockComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.CustomTextComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.CustomTextureComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.CycleComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.PlatformComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.StationNameComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.WeatherIconComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.WeatherTextComponent;
import forge.com.lx862.jcm.mod.data.pids.preset.components.base.ComponentParser;
import forge.com.lx862.jcm.mod.render.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public abstract class PIDSComponent
implements RenderHelper {
    public static final HashMap<String, ComponentParser> componentList = new HashMap();
    protected final double x;
    protected final double y;
    protected final double width;
    protected final double height;

    public PIDSComponent(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean canRender(PIDSContext context) {
        return true;
    }

    public abstract void render(GraphicsHolder var1, GuiDrawing var2, Direction var3, PIDSContext var4);

    public static PIDSComponent parse(JsonObject jsonObject) {
        String name = jsonObject.get("component").getAsString();
        double x = jsonObject.get("x").getAsDouble();
        double y = jsonObject.get("y").getAsDouble();
        double width = jsonObject.get("width").getAsDouble();
        double height = jsonObject.get("height").getAsDouble();
        for (Map.Entry<String, ComponentParser> entry : componentList.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            return entry.getValue().parse(x, y, width, height, jsonObject);
        }
        return null;
    }

    static {
        componentList.put("arrival_destination", ArrivalDestinationComponent::parseComponent);
        componentList.put("arrival_eta", ArrivalETAComponent::parseComponent);
        componentList.put("arrival_car", ArrivalCarComponent::parseComponent);
        componentList.put("clock", ClockComponent::parseComponent);
        componentList.put("cycle", CycleComponent::parseComponent);
        componentList.put("custom_text", CustomTextComponent::parseComponent);
        componentList.put("custom_texture", CustomTextureComponent::parseComponent);
        componentList.put("platform_text", PlatformComponent::parseComponent);
        componentList.put("station_name", StationNameComponent::parseComponent);
        componentList.put("weather_text", WeatherTextComponent::parseComponent);
        componentList.put("weather_icon", WeatherIconComponent::parseComponent);
    }
}

