/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.item;

import forge.com.lx862.jcm.mod.registry.Blocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.BlockPSDTop;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.block.TripleHorizontalBlock;

public class ItemDRLAPG
extends ItemExtension
implements IBlock {
    private final EnumPSDAPGItem item;
    private final EnumPSDAPGType type;

    public ItemDRLAPG(EnumPSDAPGItem item, EnumPSDAPGType type, ItemSettings itemSettings) {
        super(itemSettings);
        this.item = item;
        this.type = type;
    }

    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        int horizontalBlocks;
        int n = this.item.isDoor ? (this.type.isOdd ? 3 : 2) : (horizontalBlocks = 1);
        if (ItemDRLAPG.blocksNotReplaceable(context, horizontalBlocks, this.type.isPSD ? 3 : 2, this.getBlockStateFromItem().getBlock())) {
            return ActionResult.FAIL;
        }
        World world = context.getWorld();
        Direction playerFacing = context.getPlayerFacing();
        BlockPos pos = context.getBlockPos().offset(context.getSide());
        for (int x = 0; x < horizontalBlocks; ++x) {
            BlockPos newPos = pos.offset(playerFacing.rotateYClockwise(), x);
            for (int y = 0; y < 2; ++y) {
                BlockState state = this.getBlockStateFromItem().with(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGBase.FACING.data), (Comparable)playerFacing.data).with(new org.mtr.mapping.holder.Property((Property)ItemDRLAPG.HALF.data), (Comparable)(y == 1 ? IBlock.DoubleBlockHalf.UPPER : IBlock.DoubleBlockHalf.LOWER));
                if (this.item.isDoor) {
                    BlockState neighborState = state.with(new org.mtr.mapping.holder.Property((Property)ItemDRLAPG.SIDE.data), (Comparable)(x == 0 ? IBlock.EnumSide.LEFT : IBlock.EnumSide.RIGHT));
                    if (this.type.isOdd) {
                        neighborState = neighborState.with(new org.mtr.mapping.holder.Property((Property)TripleHorizontalBlock.CENTER.data), (Comparable)Boolean.valueOf(x > 0 && x < horizontalBlocks - 1));
                    }
                    world.setBlockState(newPos.up(y), neighborState);
                    continue;
                }
                world.setBlockState(newPos.up(y), state.with(new org.mtr.mapping.holder.Property((Property)ItemDRLAPG.SIDE_EXTENDED.data), (Comparable)IBlock.EnumSide.SINGLE));
            }
            if (!this.type.isPSD) continue;
            world.setBlockState(newPos.up(2), BlockPSDTop.getActualState((WorldAccess)WorldAccess.cast((HolderBase)world), (BlockPos)newPos.up(2)));
        }
        context.getStack().decrement(1);
        return ActionResult.SUCCESS;
    }

    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable((String)(this.type.isLift ? (this.type.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even") : "tooltip.mtr." + this.item.asString2()), (Object[])new Object[0]).formatted(TextFormatting.GRAY));
    }

    private BlockState getBlockStateFromItem() {
        switch (this.item) {
            case DOOR: {
                return Blocks.APG_DOOR_DRL.get().getDefaultState();
            }
            case GLASS: {
                return Blocks.APG_GLASS_DRL.get().getDefaultState();
            }
            case GLASS_END: {
                return Blocks.APG_GLASS_END_DRL.get().getDefaultState();
            }
        }
        return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
    }

    public static boolean blocksNotReplaceable(ItemUsageContext context, int width, int height, @Nullable Block blacklistBlock) {
        Direction facing = context.getPlayerFacing();
        World world = context.getWorld();
        BlockPos startingPos = context.getBlockPos().offset(context.getSide());
        for (int x = 0; x < width; ++x) {
            BlockPos offsetPos = startingPos.offset(facing.rotateYClockwise(), x);
            if (blacklistBlock != null) {
                boolean isBlacklistedBelow = world.getBlockState(offsetPos.down()).isOf(blacklistBlock);
                boolean isBlacklistedAbove = world.getBlockState(offsetPos.up(height)).isOf(blacklistBlock);
                if (isBlacklistedBelow || isBlacklistedAbove) {
                    return true;
                }
            }
            for (int y = 0; y < height; ++y) {
                if (world.getBlockState(offsetPos.up(y)).getBlock().equals((Object)org.mtr.mapping.holder.Blocks.getAirMapped())) continue;
                return true;
            }
        }
        return false;
    }

    public static enum EnumPSDAPGItem implements StringIdentifiable
    {
        DOOR("psd_apg_door", true),
        GLASS("psd_apg_glass", false),
        GLASS_END("psd_apg_glass_end", false);

        private final String name;
        private final boolean isDoor;

        private EnumPSDAPGItem(String name, boolean isDoor) {
            this.name = name;
            this.isDoor = isDoor;
        }

        @Nonnull
        public String asString2() {
            return this.name;
        }
    }

    public static enum EnumPSDAPGType {
        APG(false, false, false);

        private final boolean isPSD;
        private final boolean isOdd;
        private final boolean isLift;

        private EnumPSDAPGType(boolean isPSD, boolean isOdd, boolean isLift) {
            this.isPSD = isPSD;
            this.isOdd = isOdd;
            this.isLift = isLift;
        }
    }
}

