/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.network.block;

import forge.com.lx862.jcm.mod.block.base.JCMBlock;
import forge.com.lx862.jcm.mod.block.entity.FareSaverBlockEntity;
import forge.com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class FareSaverUpdatePacket
extends PacketHandler {
    private final BlockPos blockPos;
    private final String prefix;
    private final int discount;

    public FareSaverUpdatePacket(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.prefix = packetBufferReceiver.readString();
        this.discount = packetBufferReceiver.readInt();
    }

    public FareSaverUpdatePacket(BlockPos blockPos, String prefix, int discount) {
        this.blockPos = blockPos;
        this.prefix = prefix;
        this.discount = discount;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeString(this.prefix);
        packetBufferSender.writeInt(this.discount);
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = serverPlayerEntity.getEntityWorld();
        BlockState state = BlockUtil.getBlockState(world, this.blockPos);
        if (state == null || !(state.getBlock().data instanceof JCMBlock)) {
            return;
        }
        ((JCMBlock)((Object)state.getBlock().data)).loopStructure(state, world, this.blockPos, (bs, be) -> {
            if (be.data instanceof FareSaverBlockEntity) {
                ((FareSaverBlockEntity)((Object)((Object)be.data))).setData(this.prefix, this.discount);
            }
        });
    }
}

