/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Rectangle;
import org.mtr.mapping.holder.MinecraftClient;

public class ClipStack {
    private static final ObjectList<Rectangle> stacks = new ObjectArrayList();

    public static void push(int x, int y, int width, int height) {
        stacks.add((Object)new Rectangle(x, y, width, height));
        ClipStack.enableClip(x, y, width, height);
    }

    public static void add(int x, int y, int width, int height) {
        Rectangle oldStack = (Rectangle)stacks.get(stacks.size() - 1);
        int clampedX = Math.max(oldStack.x, x);
        int clampedY = Math.max(oldStack.y, y);
        int oldEndY = oldStack.y + oldStack.height;
        int clampedHeight = oldEndY - clampedY;
        Rectangle rect = new Rectangle(clampedX, clampedY, width, clampedHeight);
        stacks.add((Object)rect);
        ClipStack.enableClip(rect.x, rect.y, rect.width, rect.height);
    }

    public static void pop() {
        if (stacks.isEmpty()) {
            throw new IllegalStateException("No more clip stack to be popped!");
        }
        if (stacks.size() > 1) {
            stacks.remove(stacks.size() - 1);
            Rectangle remainingLast = (Rectangle)stacks.get(stacks.size() - 1);
            ClipStack.enableClip(remainingLast.x, remainingLast.y, remainingLast.width, remainingLast.height);
        } else {
            stacks.remove(0);
            ClipStack.disableClip();
        }
    }

    private static void enableClip(int x, int y, int width, int height) {
        double scale = MinecraftClient.getInstance().getWindow().getScaleFactor();
        int windowHeight = MinecraftClient.getInstance().getWindow().getFramebufferHeight();
        RenderSystem.enableScissor((int)((int)((double)x * scale)), (int)((int)((double)windowHeight - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
    }

    public static void ensureStateCorrect() {
        if (stacks.isEmpty()) {
            ClipStack.disableClip();
        } else {
            Rectangle latestStacks = (Rectangle)stacks.get(stacks.size() - 1);
            ClipStack.enableClip(latestStacks.x, latestStacks.y, latestStacks.width, latestStacks.height);
        }
    }

    private static void disableClip() {
        RenderSystem.disableScissor();
    }
}

