/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.block;

import forge.com.lx862.jcm.mod.JCMClient;
import forge.com.lx862.jcm.mod.data.BlockProperties;
import forge.com.lx862.jcm.mod.render.RenderHelper;
import forge.com.lx862.jcm.mod.util.JCMLogger;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;

public abstract class JCMBlockEntityRenderer<T extends BlockEntityExtension>
extends BlockEntityRenderer<T>
implements RenderHelper {
    public JCMBlockEntityRenderer(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(@Nonnull T blockEntity, float tickDelta, @Nonnull GraphicsHolder graphicsHolder, int light, int i1) {
        try {
            World world = blockEntity.getWorld2();
            BlockPos pos = blockEntity.getPos2();
            if (JCMClient.getConfig().disableRendering || world == null) {
                return;
            }
            if (world.getBlockState(pos).isAir()) {
                return;
            }
            BlockState state = world.getBlockState(pos);
            this.renderCurated(blockEntity, graphicsHolder, world, state, pos, tickDelta, light, i1);
        }
        catch (Exception e) {
            JCMLogger.error("An exception occurred while rendering Block Entity!", new Object[0]);
            JCMLogger.error("This is a bug, please report to the developers of Joban Client Mod!", new Object[0]);
            throw new Error("An exception occurred while rendering Block Entity.", e);
        }
    }

    public abstract void renderCurated(T var1, GraphicsHolder var2, World var3, BlockState var4, BlockPos var5, float var6, int var7, int var8);

    public void rotateToBlockDirection(GraphicsHolder graphicsHolder, T blockEntity) {
        World world = blockEntity.getWorld2();
        if (world != null) {
            BlockState state = world.getBlockState(blockEntity.getPos2());
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)BlockProperties.FACING);
            graphicsHolder.rotateYDegrees(-facing.asRotation());
        }
    }
}

