/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.block;

import forge.com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import forge.com.lx862.jcm.mod.data.BlockProperties;
import forge.com.lx862.jcm.mod.data.pids.PIDSManager;
import forge.com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import forge.com.lx862.jcm.mod.render.block.JCMBlockEntityRenderer;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.ArrivalsCacheClient;

public abstract class PIDSRenderer<T extends PIDSBlockEntity>
extends JCMBlockEntityRenderer<T> {
    public PIDSRenderer(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void renderCurated(T blockEntity, GraphicsHolder graphicsHolder, World world, BlockState state, BlockPos pos, float tickDelta, int light, int i1) {
        LongImmutableList platforms;
        PIDSPresetBase pidsPreset = this.getPreset((PIDSBlockEntity)((Object)blockEntity));
        if (pidsPreset == null) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)BlockProperties.FACING);
        boolean[] rowHidden = new boolean[((PIDSBlockEntity)((Object)blockEntity)).getRowAmount()];
        boolean[] beRowHidden = ((PIDSBlockEntity)((Object)blockEntity)).getRowHidden();
        for (int i = 0; i < rowHidden.length; ++i) {
            rowHidden[i] = pidsPreset.isRowHidden(i) || beRowHidden[i];
        }
        if (!((PIDSBlockEntity)((Object)blockEntity)).getPlatformIds().isEmpty()) {
            platforms = new LongImmutableList((LongCollection)((PIDSBlockEntity)((Object)blockEntity)).getPlatformIds());
        } else {
            LongArrayList closestPlatforms = new LongArrayList();
            InitClient.findClosePlatform((BlockPos)pos, (int)5, e -> closestPlatforms.add(e.getId()));
            platforms = new LongImmutableList((LongList)closestPlatforms);
        }
        ObjectArrayList arrivals = ArrivalsCacheClient.INSTANCE.requestArrivals((LongCollection)platforms);
        graphicsHolder.push();
        graphicsHolder.translate(0.5, 0.5, 0.5);
        graphicsHolder.rotateYDegrees(90.0f - facing.asRotation());
        graphicsHolder.rotateZDegrees(180.0f);
        this.renderPIDS(blockEntity, pidsPreset, graphicsHolder, world, state, pos, facing, (ObjectArrayList<ArrivalResponse>)arrivals, tickDelta, rowHidden);
        graphicsHolder.pop();
    }

    public abstract void renderPIDS(T var1, PIDSPresetBase var2, GraphicsHolder var3, World var4, BlockState var5, BlockPos var6, Direction var7, ObjectArrayList<ArrivalResponse> var8, float var9, boolean[] var10);

    private PIDSPresetBase getPreset(PIDSBlockEntity blockEntity) {
        return PIDSManager.getPreset(blockEntity.getPresetId(), PIDSManager.getPreset(blockEntity.getDefaultPresetId()));
    }
}

