/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.gui.screen;

import forge.com.lx862.jcm.mod.block.entity.SoundLooperBlockEntity;
import forge.com.lx862.jcm.mod.network.block.SoundLooperUpdatePacket;
import forge.com.lx862.jcm.mod.registry.Blocks;
import forge.com.lx862.jcm.mod.registry.Networking;
import forge.com.lx862.jcm.mod.render.gui.screen.base.BlockConfigListScreen;
import forge.com.lx862.jcm.mod.render.gui.widget.BlockPosWidget;
import forge.com.lx862.jcm.mod.render.gui.widget.IntegerTextField;
import forge.com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import forge.com.lx862.jcm.mod.util.TextCategory;
import forge.com.lx862.jcm.mod.util.TextUtil;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.TextCase;

public class SoundLooperScreen
extends BlockConfigListScreen {
    private final ButtonWidgetExtension soundCategoryButton = new ButtonWidgetExtension(0, 0, 60, 20, btn -> this.setSoundCategory((this.soundCategory + 1) % SoundLooperBlockEntity.SOURCE_LIST.length));
    private final TextFieldWidgetExtension soundIdTextField;
    private final IntegerTextField repeatTickTextField;
    private final IntegerTextField soundVolumeTextField;
    private final CheckboxWidgetExtension needRedstonePowerCheckbox;
    private final CheckboxWidgetExtension limitSoundRangeCheckbox;
    private final BlockPosWidget corner1Widget;
    private final BlockPosWidget corner2Widget;
    private int soundCategory;

    public SoundLooperScreen(BlockPos blockPos, BlockPos corner1, BlockPos corner2, String soundId, int soundCategory, float volume, int repeatTick, boolean needRedstonePower, boolean limitRange) {
        super(blockPos);
        this.setSoundCategory(soundCategory);
        this.corner1Widget = new BlockPosWidget(0, 0, 120, 20);
        this.corner1Widget.setBlockPos(corner1);
        this.corner2Widget = new BlockPosWidget(0, 0, 120, 20);
        this.corner2Widget.setBlockPos(corner2);
        this.soundIdTextField = new TextFieldWidgetExtension(0, 0, 100, 20, 100, TextCase.LOWER, null, "mtr:ticket_barrier");
        this.soundIdTextField.setText2(soundId);
        this.soundVolumeTextField = new IntegerTextField(0, 0, 60, 20, 1, 1000, 100);
        this.soundVolumeTextField.setValue((int)(volume * 100.0f));
        this.repeatTickTextField = new IntegerTextField(0, 0, 60, 20, 1, 99999, 20);
        this.repeatTickTextField.setValue(repeatTick);
        this.needRedstonePowerCheckbox = new CheckboxWidgetExtension(0, 0, 20, 20, false, checked -> {});
        this.needRedstonePowerCheckbox.setChecked(needRedstonePower);
        this.limitSoundRangeCheckbox = new CheckboxWidgetExtension(0, 0, 20, 20, false, checked -> {
            if (checked.booleanValue()) {
                this.corner1Widget.setActiveMapped(true);
                this.corner2Widget.setActiveMapped(true);
            } else {
                this.corner1Widget.setActiveMapped(false);
                this.corner2Widget.setActiveMapped(false);
            }
        });
        this.limitSoundRangeCheckbox.setChecked(limitRange);
        this.corner1Widget.setActiveMapped(limitRange);
        this.corner2Widget.setActiveMapped(limitRange);
    }

    @Override
    public MutableText getScreenTitle() {
        return Blocks.SOUND_LOOPER.get().getName();
    }

    @Override
    public void addConfigEntries() {
        this.corner1Widget.addWidget(arg_0 -> ((SoundLooperScreen)this).addChild(arg_0));
        this.corner2Widget.addWidget(arg_0 -> ((SoundLooperScreen)this).addChild(arg_0));
        this.addChild(new ClickableWidget((AbstractWidget)this.soundCategoryButton));
        this.addChild(new ClickableWidget((AbstractWidget)this.soundIdTextField));
        this.addChild(new ClickableWidget((AbstractWidget)this.soundVolumeTextField));
        this.addChild(new ClickableWidget((AbstractWidget)this.repeatTickTextField));
        this.addChild(new ClickableWidget((AbstractWidget)this.needRedstonePowerCheckbox));
        this.addChild(new ClickableWidget((AbstractWidget)this.limitSoundRangeCheckbox));
        this.addChild(new ClickableWidget((AbstractWidget)this.corner1Widget));
        this.addChild(new ClickableWidget((AbstractWidget)this.corner2Widget));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.sound_category", new Object[0]), new MappedWidget(this.soundCategoryButton));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.sound_id", new Object[0]), new MappedWidget(this.soundIdTextField));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.sound_volume", new Object[0]), new MappedWidget(this.soundVolumeTextField));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.repeat_tick", new Object[0]), new MappedWidget(this.repeatTickTextField));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.need_redstone", new Object[0]), new MappedWidget(this.needRedstonePowerCheckbox));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.limit_range", new Object[0]), new MappedWidget(this.limitSoundRangeCheckbox));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.pos1", new Object[0]), new MappedWidget(this.corner1Widget));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "sound_looper.listview.title.pos2", new Object[0]), new MappedWidget(this.corner2Widget));
    }

    @Override
    public void onSave() {
        Networking.sendPacketToServer(new SoundLooperUpdatePacket(this.blockPos, this.corner1Widget.getBlockPos(), this.corner2Widget.getBlockPos(), this.soundIdTextField.getText2(), this.soundCategory, (int)this.repeatTickTextField.getNumber(), (float)this.soundVolumeTextField.getNumber() / 100.0f, this.needRedstonePowerCheckbox.isChecked2(), this.limitSoundRangeCheckbox.isChecked2()));
    }

    private void setSoundCategory(int category) {
        this.soundCategory = category >= SoundLooperBlockEntity.SOURCE_LIST.length ? 0 : category;
        this.soundCategoryButton.setMessage2(Text.cast((HolderBase)TextUtil.literal(SoundLooperBlockEntity.SOURCE_LIST[category].getName())));
    }
}

