/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.gui.widget;

import forge.com.lx862.jcm.mod.render.GuiHelper;
import forge.com.lx862.jcm.mod.render.RenderHelper;
import forge.com.lx862.jcm.mod.render.gui.widget.AbstractListItem;
import forge.com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import java.util.Objects;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class ContentItem
extends AbstractListItem {
    public DrawIconCallback drawIconCallback = null;
    public final MutableText title;
    public final MappedWidget widget;

    public ContentItem(MutableText title, MappedWidget widget, int height) {
        super(height);
        this.title = title;
        this.widget = widget;
    }

    public ContentItem(MutableText title, MappedWidget widget) {
        this(title, widget, 22);
    }

    public ContentItem setIcon(Identifier textureId) {
        this.drawIconCallback = (guiDrawing, startX, startY, width, height) -> GuiHelper.drawTexture(guiDrawing, textureId, startX, startY, width, height);
        return this;
    }

    public ContentItem setIconCallback(DrawIconCallback drawIconCallback) {
        this.drawIconCallback = drawIconCallback;
        return this;
    }

    public boolean hasIcon() {
        return this.drawIconCallback != null;
    }

    @Override
    public void draw(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, int entryX, int entryY, int width, int height, int mouseX, int mouseY, boolean widgetVisible, double elapsed, float tickDelta) {
        super.draw(graphicsHolder, guiDrawing, entryX, entryY, width, height, mouseX, mouseY, widgetVisible, elapsed, tickDelta);
        this.drawListEntry(graphicsHolder, guiDrawing, entryX, entryY, width, mouseX, mouseY, widgetVisible, elapsed, tickDelta);
    }

    @Override
    public boolean matchQuery(String searchTerm) {
        return Objects.equals(searchTerm, "") || this.title != null && this.title.getString().contains(searchTerm);
    }

    @Override
    public void positionChanged(int entryX, int entryY) {
        if (this.widget != null) {
            int offsetY = (this.height - this.widget.getHeight()) / 2;
            this.widget.setX(entryX - this.widget.getWidth());
            this.widget.setY(entryY + offsetY);
        }
    }

    @Override
    public void hidden() {
        if (this.widget != null) {
            this.widget.setVisible(false);
        }
    }

    @Override
    public void shown() {
        if (this.widget != null) {
            this.widget.setVisible(true);
        }
    }

    private void drawListEntry(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, int entryX, int entryY, int width, int mouseX, int mouseY, boolean widgetVisible, double elapsed, float tickDelta) {
        if (this.title != null) {
            this.drawListEntryDescription(graphicsHolder, entryX, entryY, width, elapsed);
        }
        if (this.widget != null) {
            this.widget.setVisible(widgetVisible);
            this.widget.render(graphicsHolder, mouseX, mouseY, tickDelta);
        }
    }

    private void drawListEntryDescription(GraphicsHolder graphicsHolder, int entryX, int entryY, int width, double elapsed) {
        int textHeight = 9;
        int iconSize = this.hasIcon() ? this.height - 5 : 0;
        int widgetWidth = this.widget == null ? 0 : this.widget.getWidth();
        int availableTextWidth = width - widgetWidth - 5 - iconSize;
        int textY = this.height / 2 - textHeight / 2;
        boolean widgetEnabled = this.widget == null || this.widget.getActive();
        graphicsHolder.push();
        graphicsHolder.translate((double)entryX, (double)entryY, 0.0);
        graphicsHolder.translate(5.0, 0.0, 0.0);
        if (this.hasIcon()) {
            this.drawIconCallback.accept(new GuiDrawing(graphicsHolder), 0, (this.height - iconSize) / 2, iconSize, iconSize);
            graphicsHolder.translate((double)(iconSize + 5), 0.0, 0.0);
        }
        int textColor = widgetEnabled ? -1 : -7829368;
        GuiHelper.drawScrollableText(graphicsHolder, this.title, elapsed, entryX + 5 + iconSize, 0, textY, availableTextWidth - iconSize - 5 - 5 - 5, textColor, true);
        graphicsHolder.pop();
    }

    @FunctionalInterface
    public static interface DrawIconCallback
    extends RenderHelper {
        public void accept(GuiDrawing var1, int var2, int var3, int var4, int var5);
    }
}

