/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.gui.widget;

import forge.com.lx862.jcm.mod.render.ClipStack;
import forge.com.lx862.jcm.mod.render.GuiHelper;
import forge.com.lx862.jcm.mod.render.RenderHelper;
import forge.com.lx862.jcm.mod.render.gui.widget.AbstractListItem;
import forge.com.lx862.jcm.mod.render.gui.widget.AbstractScrollViewWidget;
import forge.com.lx862.jcm.mod.render.gui.widget.CategoryItem;
import forge.com.lx862.jcm.mod.render.gui.widget.ContentItem;
import forge.com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class ListViewWidget
extends AbstractScrollViewWidget
implements RenderHelper,
GuiHelper {
    public static final int ENTRY_PADDING = 5;
    private final List<AbstractListItem> displayedEntryList = new ArrayList<AbstractListItem>();
    private final List<AbstractListItem> entryList = new ArrayList<AbstractListItem>();
    private float elapsed;
    private String searchTerm = "";

    public ListViewWidget() {
        super(0, 0, 0, 0);
    }

    public void setXYSize(int x, int y, int width, int height) {
        this.setX2(x);
        this.setY2(y);
        this.setWidth2(width);
        this.setHeightMapped(height);
        this.setScroll(this.currentScroll);
        this.positionWidgets(this.currentScroll);
        this.refreshDisplayedList();
    }

    public void add(MutableText text, MappedWidget widget) {
        this.add(new ContentItem(text, widget));
    }

    public void add(AbstractListItem listItem) {
        this.entryList.add(listItem);
        this.refreshDisplayedList();
    }

    public void addCategory(MutableText text) {
        this.entryList.add(new CategoryItem(text));
        this.refreshDisplayedList();
    }

    public void reset() {
        this.entryList.clear();
        this.refreshDisplayedList();
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        this.refreshDisplayedList();
    }

    private void refreshDisplayedList() {
        this.displayedEntryList.clear();
        this.entryList.forEach(e -> {
            if (e.matchQuery(this.searchTerm)) {
                e.shown();
                this.displayedEntryList.add((AbstractListItem)e);
            } else {
                e.hidden();
            }
        });
        this.positionWidgets();
        this.setScroll(this.currentScroll);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        GuiHelper.drawRectangle(new GuiDrawing(graphicsHolder), this.getX2(), this.getY2(), this.f_93618_, this.f_93619_, 0x4F4C4C4C);
        super.render(graphicsHolder, mouseX, mouseY, tickDelta);
    }

    @Override
    public void renderContent(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        this.elapsed += tickDelta / 20.0f;
        int incY = 0;
        for (AbstractListItem abstractListItem : this.displayedEntryList) {
            ClipStack.ensureStateCorrect();
            int entryX = this.getX2();
            int entryY = this.getY2() + incY - (int)this.currentScroll;
            boolean widgetVisible = false;
            if (abstractListItem instanceof ContentItem) {
                ContentItem contentItem = (ContentItem)abstractListItem;
                boolean topLeftVisible = this.inRectangle(contentItem.widget.getX(), contentItem.widget.getY(), this.getX2(), this.getY2(), this.getWidth2(), this.getHeight2());
                boolean bottomRightVisible = this.inRectangle(contentItem.widget.getX() + contentItem.widget.getWidth(), contentItem.widget.getY() + contentItem.widget.getHeight(), this.getX2(), this.getY2(), this.getWidth2(), this.getHeight2());
                widgetVisible = topLeftVisible && bottomRightVisible;
            }
            abstractListItem.draw(graphicsHolder, guiDrawing, entryX, entryY, this.f_93618_ - this.getScrollbarOffset(), this.f_93619_, mouseX, mouseY, widgetVisible, this.elapsed, tickDelta);
            incY += abstractListItem.height;
        }
    }

    @Override
    public void setScroll(double newScroll) {
        super.setScroll(newScroll);
        this.positionWidgets();
    }

    @Override
    protected int getContentHeight() {
        int entryHeight = 0;
        for (AbstractListItem entry : this.displayedEntryList) {
            entryHeight += entry.height;
        }
        return entryHeight;
    }

    public void positionWidgets() {
        this.positionWidgets(this.currentScroll);
    }

    private void positionWidgets(double scroll) {
        int startX = this.getX2();
        int startY = this.getY2();
        int incY = 0;
        for (AbstractListItem listItem : this.displayedEntryList) {
            int entryY = startY + incY;
            int x = startX + this.f_93618_ - this.getScrollbarOffset() - 5;
            listItem.positionChanged(x, (int)(-scroll) + entryY);
            incY += listItem.height;
        }
    }
}

