/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.text;

import forge.com.lx862.jcm.mod.render.text.TextAlignment;
import forge.com.lx862.jcm.mod.render.text.WidthInfo;
import forge.com.lx862.jcm.mod.render.text.font.FontManager;
import forge.com.lx862.jcm.mod.render.text.font.FontSet;
import forge.com.lx862.jcm.mod.util.TextUtil;
import java.awt.Font;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;

public class TextInfo {
    private final String content;
    private final WidthInfo widthInfo;
    private Identifier fontId;
    private TextAlignment textAlignment = TextAlignment.LEFT;
    private int textColor;
    private boolean forScrollingText = false;

    public TextInfo(String content) {
        this.content = content;
        this.widthInfo = new WidthInfo();
    }

    public TextInfo(MutableText text) {
        this.content = text.getString();
        this.widthInfo = new WidthInfo();
    }

    public String getContent() {
        return this.content;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public WidthInfo getWidthInfo() {
        return this.widthInfo;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public boolean isForScrollingText() {
        return this.forScrollingText;
    }

    public TextInfo withScrollingText() {
        this.forScrollingText = true;
        return this;
    }

    public TextInfo withColor(TextFormatting formatting) {
        if (formatting.getColorValue() != null) {
            this.textColor = formatting.getColorValue();
        }
        return this;
    }

    public TextInfo withColor(int color) {
        this.textColor = color;
        return this;
    }

    public TextInfo withTextAlignment(TextAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    public TextInfo withFixedWidth(int targetWidth) {
        this.widthInfo.setFixedWidth(targetWidth);
        return this;
    }

    public TextInfo withMaxWidth(float maxWidth) {
        this.widthInfo.setMaxWidth(maxWidth);
        return this;
    }

    public TextInfo withFont(String font) {
        return this.withFont(new Identifier(font));
    }

    public TextInfo withFont(Identifier fontId) {
        this.fontId = fontId;
        return this;
    }

    public FontSet getFontSet() {
        FontSet preloadedFont = FontManager.getFontSet(this.fontId);
        if (preloadedFont != null) {
            return preloadedFont;
        }
        return new FontSet(new Font("SansSerif", 0, 1));
    }

    public MutableText toMutableText() {
        MutableText text = TextUtil.literal(this.content);
        if (this.fontId != null) {
            text = TextUtil.withFont(text, this.fontId);
        }
        return text;
    }

    public TextInfo copy(String newContent) {
        TextInfo ti = new TextInfo(newContent);
        ti.withColor(this.textColor);
        ti.withFont(this.fontId);
        return ti;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextInfo)) {
            return false;
        }
        TextInfo other = (TextInfo)o;
        return other.content.equals(this.content) && other.textColor == this.textColor && this.forScrollingText == other.forScrollingText && this.fontId.equals((Object)other.fontId);
    }
}

