/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.render.text;

import forge.com.lx862.jcm.mod.JCMClient;
import forge.com.lx862.jcm.mod.render.RenderHelper;
import forge.com.lx862.jcm.mod.render.text.TextInfo;
import forge.com.lx862.jcm.mod.render.text.TextureTextRenderer;
import forge.com.lx862.jcm.mod.render.text.VanillaTextRenderer;
import forge.com.lx862.jcm.mod.render.text.font.FontManager;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class TextRenderingManager
implements RenderHelper {
    public static void initialize() {
        if (JCMClient.getConfig().useNewTextRenderer) {
            FontManager.initialize();
            TextureTextRenderer.initialize();
        } else if (TextureTextRenderer.initialized()) {
            TextureTextRenderer.close();
        }
    }

    public static void bind(GraphicsHolder graphicsHolder) {
        if (JCMClient.getConfig().useNewTextRenderer) {
            TextureTextRenderer.bindTexture(graphicsHolder);
        }
    }

    public static void draw(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, TextInfo text, double x, double y) {
        TextRenderingManager.drawInternal(graphicsHolder, guiDrawing, text, null, x, y);
    }

    public static void draw(GraphicsHolder graphicsHolder, TextInfo text, Direction facing, double x, double y) {
        TextRenderingManager.drawInternal(graphicsHolder, null, text, facing, x, y);
    }

    private static void drawInternal(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, TextInfo text, Direction facing, double x, double y) {
        if (text.getContent().isEmpty()) {
            return;
        }
        if (!JCMClient.getConfig().useNewTextRenderer) {
            VanillaTextRenderer.draw(graphicsHolder, text, x, y);
        } else if (guiDrawing != null) {
            TextureTextRenderer.draw(guiDrawing, text, x, y);
        } else {
            TextureTextRenderer.draw(graphicsHolder, text, facing, x, y);
        }
    }

    public static int getTextWidth(TextInfo text) {
        if (!JCMClient.getConfig().useNewTextRenderer) {
            return VanillaTextRenderer.getTextWidth(text);
        }
        return TextureTextRenderer.getPhysicalWidth(text);
    }
}

