/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.resources.mcmeta;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.com.lx862.jcm.mod.data.Pair;
import forge.com.lx862.jcm.mod.resources.mcmeta.McMetaFrame;

public class McMeta {
    private int tickElapsed;
    private int defaultFrameTime = 1;
    private int verticalPart;
    private int currentPart = 0;
    public McMetaFrame[] frames;

    public static McMeta parse(JsonObject jsonObject) {
        McMeta mcMeta = new McMeta();
        JsonObject animation = jsonObject.getAsJsonObject("animation");
        if (animation.has("frametime")) {
            mcMeta.setDefaultFrameTime(animation.get("frametime").getAsInt());
        }
        if (animation.has("frames")) {
            JsonArray customFrameOrderArray = animation.get("frames").getAsJsonArray();
            McMetaFrame[] customFrameOrder = new McMetaFrame[customFrameOrderArray.size()];
            for (int i = 0; i < customFrameOrderArray.size(); ++i) {
                JsonElement frameData = customFrameOrderArray.get(i);
                if (frameData.isJsonObject()) {
                    JsonObject frameDataObject = frameData.getAsJsonObject();
                    int order = frameDataObject.get("index").getAsInt();
                    int duration = frameDataObject.has("time") ? frameDataObject.get("time").getAsInt() : mcMeta.defaultFrameTime;
                    customFrameOrder[i] = new McMetaFrame(order, duration);
                    continue;
                }
                customFrameOrder[i] = new McMetaFrame(customFrameOrderArray.get(i).getAsInt(), mcMeta.defaultFrameTime);
            }
            mcMeta.setFrames(customFrameOrder);
        }
        return mcMeta;
    }

    public void setFrames(McMetaFrame[] frames) {
        this.frames = frames;
    }

    public void setDefaultFrameTime(int defaultFrameTime) {
        this.defaultFrameTime = defaultFrameTime;
    }

    public Pair<Float, Float> getUV() {
        float onePart = 1.0f / (float)this.verticalPart;
        int frameNow = this.frames[this.currentPart].getOrder();
        float startV = onePart * (float)frameNow;
        return new Pair<Float, Float>(Float.valueOf(startV), Float.valueOf(startV + onePart));
    }

    public void setVerticalPart(int part) {
        this.verticalPart = part;
        if (this.frames == null) {
            this.frames = new McMetaFrame[this.verticalPart];
            for (int i = 0; i < this.verticalPart; ++i) {
                this.frames[i] = new McMetaFrame(i, this.defaultFrameTime);
            }
            this.setFrames(this.frames);
        }
    }

    public void tick() {
        if (this.tickElapsed >= this.frames[this.currentPart].getDuration()) {
            this.tickElapsed = 0;
            this.currentPart = this.currentPart >= this.frames.length - 1 ? 0 : ++this.currentPart;
        }
        ++this.tickElapsed;
    }
}

