/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lx862.jcm.mod.scripting.mtr.vehicle;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.mtr.core.data.PathData;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleCar;
import org.mtr.mod.data.VehicleExtension;

public class VehicleWrapper {
    private final VehicleExtension vehicleExtension;
    private final boolean[] doorLeftOpen;
    private final boolean[] doorRightOpen;

    public VehicleWrapper(VehicleExtension vehicleExtension) {
        this.vehicleExtension = vehicleExtension;
        this.doorLeftOpen = new boolean[this.trainCars()];
        this.doorRightOpen = new boolean[this.trainCars()];
        for (int i = 0; i < this.trainCars(); ++i) {
            this.doorLeftOpen[i] = this.doorValue() > 0.0;
            this.doorRightOpen[i] = this.doorValue() > 0.0;
        }
    }

    public boolean shouldRender() {
        return true;
    }

    public boolean shouldRenderDetail() {
        return true;
    }

    public String trainTypeId(int carIndex) {
        if (carIndex >= this.vehicleExtension.vehicleExtraData.immutableVehicleCars.size()) {
            return null;
        }
        return ((VehicleCar)this.vehicleExtension.vehicleExtraData.immutableVehicleCars.get(carIndex)).getVehicleId();
    }

    public String baseTrainType(int carIndex) {
        throw new NotImplementedException("Not implemented yet.");
    }

    public long id() {
        return this.vehicleExtension.getId();
    }

    public TransportMode transportMode() {
        return this.vehicleExtension.getTransportMode();
    }

    public int trainCars() {
        return this.vehicleExtension.vehicleExtraData.immutableVehicleCars.size();
    }

    public double accelerationConstant() {
        return this.vehicleExtension.vehicleExtraData.getAcceleration();
    }

    public boolean manualAllowed() {
        return this.vehicleExtension.vehicleExtraData.getIsManualAllowed();
    }

    public double maxManualSpeed() {
        return this.vehicleExtension.vehicleExtraData.getMaxManualSpeed();
    }

    public int manualToAutomaticTime() {
        throw new NotImplementedException("Not implemented yet.");
    }

    public double railProgress() {
        throw new NotImplementedException("Not implemented yet.");
    }

    public double speed() {
        return this.vehicleExtension.getSpeed();
    }

    public double doorValue() {
        return this.vehicleExtension.persistentVehicleData.getDoorValue();
    }

    public List<PathData> path() {
        return this.vehicleExtension.vehicleExtraData.immutablePath;
    }

    public boolean isDoorOpening() {
        return this.vehicleExtension.persistentVehicleData.getAdjustedDoorMultiplier(this.vehicleExtension.vehicleExtraData) > 0;
    }

    public boolean isCurrentlyManual() {
        return this.vehicleExtension.vehicleExtraData.getIsCurrentlyManual();
    }

    public boolean isReversed() {
        return this.vehicleExtension.getReversed();
    }

    public boolean isOnRoute() {
        return this.vehicleExtension.getIsOnRoute();
    }
}

