/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.BackHalfShaftInstance;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BearingInstance<B extends KineticBlockEntity>
extends BackHalfShaftInstance<B>
implements DynamicInstance {
    final OrientedData topInstance;
    final class_7833 rotationAxis;
    final Quaternionf blockOrientation;

    public BearingInstance(MaterialManager materialManager, B blockEntity) {
        super(materialManager, blockEntity);
        class_2350 facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12525);
        this.rotationAxis = class_7833.method_46356((Vector3f)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.axis).method_23955());
        this.blockOrientation = BearingInstance.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingBlockEntity)blockEntity).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        this.topInstance = (OrientedData)this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    public void beginFrame() {
        float interpolatedAngle = ((IBearingBlockEntity)((Object)((KineticBlockEntity)this.blockEntity))).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternionf rot = this.rotationAxis.rotationDegrees(interpolatedAngle);
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.topInstance});
    }

    @Override
    public void remove() {
        super.remove();
        this.topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(class_2350 facing) {
        Quaternionf orientation = facing.method_10166().method_10179() ? class_7833.field_40716.rotationDegrees(AngleHelper.horizontalAngle(facing.method_10153())) : new Quaternionf();
        orientation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f - AngleHelper.verticalAngle(facing)));
        return orientation;
    }
}

