/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gauge;

import com.simibubi.create.AllPackets;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.GaugeObservedPacket;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class StressGaugeBlockEntity
extends GaugeBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;
    static class_2338 lastSent;

    public StressGaugeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.STRESSOMETER, AllAdvancements.STRESSOMETER_MAXED);
    }

    @Override
    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.isOverStressed() ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? Color.mixColors(65280, 0xFFFF00, this.dialTarget * 2.0f) : (this.dialTarget < 1.0f ? Color.mixColors(0xFFFF00, 0xFF0000, this.dialTarget * 2.0f - 1.0f) : 0xFF0000);
        }
        this.sendData();
        this.method_5431();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.method_5431();
            return;
        }
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        Lang.translate("gui.stressometer.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        if (this.getTheoreticalSpeed() == 0.0f) {
            Lang.text(TooltipHelper.makeProgressBar(3, 0)).translate("gui.stressometer.no_rotation", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText(stressFraction).forGoggles(tooltip);
            Lang.translate("gui.stressometer.capacity", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            LangBuilder su = Lang.translate("generic.unit.stress", new Object[0]);
            LangBuilder stressTip = Lang.number(remainingCapacity).add(su).style(IRotate.StressImpact.of(stressFraction).getRelativeColor());
            if (remainingCapacity != capacity) {
                stressTip.text(class_124.field_1080, " / ").add(Lang.number(capacity).add(su).style(class_124.field_1063));
            }
            stressTip.forGoggles(tooltip, 1);
        }
        if (!this.field_11867.equals((Object)lastSent)) {
            lastSent = this.field_11867;
            AllPackets.getChannel().sendToServer((C2SPacket)new GaugeObservedPacket(lastSent));
        }
        return true;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket && this.field_11867 != null && this.field_11867.equals((Object)lastSent)) {
            lastSent = null;
        }
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }

    public void onObserved() {
        this.award(AllAdvancements.STRESSOMETER);
        if (class_3532.method_15347((float)this.dialTarget, (float)1.0f)) {
            this.award(AllAdvancements.STRESSOMETER_MAXED);
        }
    }
}

