/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import java.util.concurrent.Future;
import journeymap.client.api.display.ImageOverlay;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.TextProperties;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class DrawImageStep
extends BaseOverlayDrawStep<ImageOverlay> {
    private Point2D.Double northWestPosition;
    private Point2D.Double southEastPosition;
    private volatile Future<Texture> iconFuture;
    private Texture iconTexture;
    private boolean hasError;

    public DrawImageStep(ImageOverlay marker) {
        super(marker);
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (!this.isOnScreen(graphics.method_51448(), xOffset, yOffset, gridRenderer, rotation)) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            this.ensureTexture();
            if (!this.hasError && this.iconTexture != null) {
                MapImage icon = ((ImageOverlay)this.overlay).getImage();
                double width = this.screenBounds.width;
                double height = this.screenBounds.height;
                DrawUtil.drawColoredSprite(graphics.method_51448(), this.iconTexture, width, height, 0.0, 0.0, icon.getDisplayWidth(), icon.getDisplayHeight(), icon.getColor(), icon.getOpacity(), this.northWestPosition.x + xOffset, this.northWestPosition.y + yOffset, 1.0f, icon.getRotation());
            }
        } else {
            super.drawText(graphics.method_51448(), buffers, pass, xOffset, yOffset, gridRenderer, fontScale, rotation);
        }
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            if (this.iconFuture == null || this.iconFuture.isCancelled()) {
                this.iconFuture = TextureCache.scheduleTextureTask(() -> {
                    MapImage image = ((ImageOverlay)this.overlay).getImage();
                    class_2960 resourceLocation = image.getImageLocation();
                    class_2960 fake = new class_2960("fake", CommonConstants.getSafeString(((ImageOverlay)this.overlay).getGuid(), "-").toLowerCase(Locale.ROOT));
                    if (resourceLocation == null) {
                        DynamicTextureImpl texture = new DynamicTextureImpl(image.getImage());
                        class_310.method_1551().method_1531().method_4616(fake, (class_1044)texture);
                        return TextureCache.getTexture(fake);
                    }
                    return TextureCache.getTexture(resourceLocation, fake);
                });
            } else if (this.iconFuture.isDone()) {
                this.iconTexture = this.iconFuture.get();
                ((class_1044)this.iconTexture).method_23207();
                this.iconFuture = null;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting ImageOverlay marimage upperTexture: " + e, (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(class_4587 poseStack, GridRenderer gridRenderer, double rotation) {
        this.northWestPosition = gridRenderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getNorthWestPoint());
        this.southEastPosition = gridRenderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getSouthEastPoint());
        this.screenBounds = new Rectangle2D.Double(this.northWestPosition.x, this.northWestPosition.y, 0.0, 0.0);
        this.screenBounds.add(this.southEastPosition);
        TextProperties textProperties = ((ImageOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ImageOverlay, DrawImageStep> {
        public DrawImageStep load(ImageOverlay overlay) throws Exception {
            return new DrawImageStep(overlay);
        }
    }
}

