/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.ui.GuiUtils;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.SliderButton;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_757;

public class IntSliderButton
extends Button
implements IConfigFieldHolder<IntegerField>,
SliderButton {
    public String prefix = "";
    public boolean dragging = false;
    public int minValue = 0;
    public int maxValue = 0;
    public String suffix = "";
    public boolean drawString = true;
    IntegerField field;

    public IntSliderButton(IntegerField field, String prefix, String suf) {
        this(field, prefix, suf, true);
    }

    public IntSliderButton(IntegerField field, String prefix, String suf, boolean drawStr) {
        super(prefix);
        this.minValue = field.getMinValue();
        this.maxValue = field.getMaxValue();
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get());
        this.disabledLabelColor = 0x404040;
    }

    @Override
    protected void renderBg(class_332 graphics, class_310 mc, int mouseX, int mouseY) {
        double sliderValue = this.getSliderValue();
        RenderWrapper.setShader(class_757::method_34542);
        GuiUtils.drawContinuousTexturedBox(graphics.method_51448(), field_22757, super.method_46426() + 1 + (int)(sliderValue * (double)(this.field_22758 - 10)), super.method_46427() + 1, 0, 66, 8, this.field_22759 - 2, 200, 20, 2, 3, 2, 2, 0.0f);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.field_22764 && this.isEnabled() && this.method_25405(mouseX, mouseY) && this.dragging) {
            this.setSliderValue((mouseX - (double)(super.method_46426() + 4)) / (double)(this.field_22758 - 8));
            if (this.clickListeners != null) {
                this.checkClickListeners();
            }
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(super.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            this.dragging = true;
            this.setValueFromMouse(mouseX);
            this.checkClickListeners();
            return true;
        }
        return false;
    }

    public double getSliderValue() {
        return ((double)this.field.get().intValue() - (double)this.minValue * 1.0) / (double)(this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        if (sliderValue < 0.0) {
            sliderValue = 0.0;
        }
        if (sliderValue > 1.0) {
            sliderValue = 1.0;
        }
        int intVal = (int)Math.round(sliderValue * (double)(this.maxValue - this.minValue) + (double)this.minValue);
        this.setValue(intVal);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.method_25355((class_2561)Constants.getStringTextComponent(this.prefix + this.field.get() + this.suffix));
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        this.field.save();
        this.checkClickListeners();
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int max = fr.method_1727(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.method_1727(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean method_25404(int key, int value, int modifier) {
        if (this.isEnabled()) {
            if (key == 263 || key == 264 || key == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - 1));
                return true;
            }
            if (key == 262 || key == 265 || key == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + 1));
                return true;
            }
        }
        return false;
    }

    public int getValue() {
        return this.field.get();
    }

    public void setValue(int value) {
        value = Math.min(value, this.maxValue);
        value = Math.max(value, this.minValue);
        if (this.field.get() != value) {
            this.field.set((Object)value);
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public IntegerField getConfigField() {
        return this.field;
    }
}

