/*
 * Decompiled with CFR 0.152.
 */
package net.wisecase2.stutterfix;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import net.wisecase2.stutterfix.config.ThreadConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StutterFix
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stutterfix");
    public static boolean isClientInitialized = false;
    public static ThreadConfig threadconfig = new ThreadConfig();
    public static boolean isConfigInitialized = false;
    public static ExecutorService saveThread = Executors.newSingleThreadExecutor();
    public static boolean removeYieldOption = !FabricLoader.getInstance().isModLoaded("vulkanmod");
    public static ExecutorService mainWorkerExecutor;
    public static Thread renderThread;
    public static Thread serverThread;
    public static boolean isInitializedMainWorkerExecutor;
    public static boolean isInitializedRenderThread;
    public static boolean isInitializedServerThread;

    public static void loadMainWorkerExecutor() {
        int threadCut;
        int threadCount;
        if (isConfigInitialized) {
            threadCount = StutterFix.threadconfig.mainWorkerExecutorCount;
            threadCut = StutterFix.threadconfig.mainWorkerExecutorPriorityCut;
        } else {
            threadCount = StutterFix.getDefaultStutterFixMainWorkerExecutorCount();
            threadCut = threadCount / 2;
        }
        AtomicInteger NEXT_WORKER_ID = new AtomicInteger(0);
        mainWorkerExecutor = new ForkJoinPool(threadCount, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("Worker-Main-" + NEXT_WORKER_ID.getAndIncrement());
            if (NEXT_WORKER_ID.get() > threadCut) {
                forkJoinWorkerThread.setPriority(1);
            }
            return forkJoinWorkerThread;
        }, StutterFix::uncaughtExceptionHandler, true);
        isInitializedMainWorkerExecutor = true;
    }

    public static void loadRenderThread(Thread thread) {
        renderThread = thread;
        isInitializedRenderThread = true;
    }

    public static void loadServerThread(Thread thread) {
        serverThread = thread;
        isInitializedServerThread = true;
    }

    public static void configPriorityRenderThread() {
        if (isConfigInitialized && isInitializedRenderThread) {
            renderThread.setPriority(StutterFix.threadconfig.renderThreadPriority);
        }
    }

    public static void configPriorityServerThread() {
        if (isConfigInitialized && isInitializedServerThread) {
            serverThread.setPriority(StutterFix.threadconfig.serverThreadPriority);
        }
    }

    public static void reloadAllConfigs() {
        StutterFix.loadMainWorkerExecutor();
        StutterFix.configPriorityRenderThread();
        StutterFix.configPriorityServerThread();
    }

    public void onInitialize() {
        threadconfig = ThreadConfig.readConfig("stutterfix-config.json");
        saveThread.execute(() -> threadconfig.saveConfig());
        isConfigInitialized = true;
        StutterFix.reloadAllConfigs();
    }

    public static int getDefaultStutterFixMainWorkerExecutorCount() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int vanillaThreadsCount = class_3532.method_15340((int)(availableProcessors - 1), (int)1, (int)StutterFix.getMaxBackgroundThreads());
        int stutterFixThreadsCount = availableProcessors >= 6 ? availableProcessors - 5 : 1;
        return Math.min(vanillaThreadsCount, stutterFixThreadsCount);
    }

    public static int getDefaultVanillaMainWorkerExecutorCount() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return class_3532.method_15340((int)(availableProcessors - 1), (int)1, (int)StutterFix.getMaxBackgroundThreads());
    }

    public static int getMaxBackgroundThreads() {
        String string = System.getProperty("max.bg.threads");
        if (string != null) {
            try {
                int i = Integer.parseInt(string);
                if (i >= 1 && i <= 255) {
                    return i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 255;
    }

    public static void uncaughtExceptionHandler(Thread thread, Throwable throwable) {
    }

    static {
        isInitializedMainWorkerExecutor = false;
        isInitializedRenderThread = false;
        isInitializedServerThread = false;
    }
}

