/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.MishangucRules;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.ColoredBlock;
import pers.solid.mishang.uc.block.StandingSignBlock;
import pers.solid.mishang.uc.blockentity.ColoredBlockEntity;
import pers.solid.mishang.uc.blockentity.HungSignBlockEntity;
import pers.solid.mishang.uc.blockentity.MishangucBlockEntities;
import pers.solid.mishang.uc.blockentity.StandingSignBlockEntity;
import pers.solid.mishang.uc.blockentity.WallSignBlockEntity;
import pers.solid.mishang.uc.blocks.MishangucBlocks;
import pers.solid.mishang.uc.item.CarryingToolItem;
import pers.solid.mishang.uc.item.DataTagToolItem;
import pers.solid.mishang.uc.item.MishangucItems;
import pers.solid.mishang.uc.render.HungSignBlockEntityRenderer;
import pers.solid.mishang.uc.render.RendersBeforeOutline;
import pers.solid.mishang.uc.render.RendersBlockOutline;
import pers.solid.mishang.uc.render.StandingSignBlockEntityRenderer;
import pers.solid.mishang.uc.render.WallSignBlockEntityRenderer;
import pers.solid.mishang.uc.screen.HungSignBlockEditScreen;
import pers.solid.mishang.uc.screen.StandingSignBlockEditScreen;
import pers.solid.mishang.uc.screen.WallSignBlockEditScreen;

@Environment(value=EnvType.CLIENT)
public class MishangucClient
implements ClientModInitializer {
    public static final AtomicReference<MishangucRules.ToolAccess> CLIENT_FORCE_PLACING_TOOL_ACCESS = new AtomicReference<MishangucRules.ToolAccess>(MishangucRules.ToolAccess.CREATIVE_ONLY);
    public static final AtomicReference<MishangucRules.ToolAccess> CLIENT_CARRYING_TOOL_ACCESS = new AtomicReference<MishangucRules.ToolAccess>(MishangucRules.ToolAccess.ALL);

    public void onInitializeClient() {
        MishangucClient.registerBlockLayers();
        MishangucClient.registerRenderEvents();
        MishangucClient.registerBlockEntityRenderers();
        MishangucClient.registerBlockColors();
        MishangucClient.registerNetworking();
        MishangucClient.registerModelPredicateProviders();
    }

    private static void registerModelPredicateProviders() {
        class_5272.method_27879((class_1792)MishangucItems.EXPLOSION_TOOL, (class_2960)Mishanguc.id("explosion_power"), (class_6395)new class_6395(){

            public float unclampedCall(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
                return MishangucItems.EXPLOSION_TOOL.power(stack);
            }

            public float call(class_1799 itemStack, @Nullable class_638 clientWorld, @Nullable class_1309 livingEntity, int i) {
                return this.unclampedCall(itemStack, clientWorld, livingEntity, i);
            }
        });
        class_5272.method_27879((class_1792)MishangucItems.EXPLOSION_TOOL, (class_2960)Mishanguc.id("explosion_create_fire"), (stack, world, entity, seed) -> MishangucItems.EXPLOSION_TOOL.createFire(stack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)MishangucItems.FAST_BUILDING_TOOL, (class_2960)Mishanguc.id("fast_building_range"), (stack, world, entity, seed) -> (float)MishangucItems.FAST_BUILDING_TOOL.getRange(stack) / 64.0f);
        class_5272.method_27879((class_1792)MishangucItems.CARRYING_TOOL, (class_2960)Mishanguc.id("is_holding_block"), (stack, world, entity, seed) -> BooleanUtils.toInteger((boolean)CarryingToolItem.hasHoldingBlockState(stack)));
        class_5272.method_27879((class_1792)MishangucItems.CARRYING_TOOL, (class_2960)Mishanguc.id("is_holding_entity"), (stack, world, entity, seed) -> BooleanUtils.toInteger((boolean)CarryingToolItem.hasHoldingEntity(stack)));
    }

    private static void registerNetworking() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("mishanguc", "edit_sign"), (client, handler, buf, responseSender) -> {
            try {
                class_2586 blockEntity;
                class_2338 blockPos = buf.method_10811();
                class_2586 class_25862 = blockEntity = client.field_1687 != null ? client.field_1687.method_8321(blockPos) : null;
                if (blockEntity instanceof HungSignBlockEntity) {
                    HungSignBlockEntity hungSignBlockEntity = (HungSignBlockEntity)blockEntity;
                    class_2350 direction = (class_2350)buf.method_10818(class_2350.class);
                    client.execute(() -> client.method_1507((class_437)new HungSignBlockEditScreen(hungSignBlockEntity, direction, blockPos)));
                } else if (blockEntity instanceof WallSignBlockEntity) {
                    WallSignBlockEntity wallSignBlockEntity = (WallSignBlockEntity)blockEntity;
                    client.execute(() -> client.method_1507((class_437)new WallSignBlockEditScreen(wallSignBlockEntity, blockPos)));
                } else if (blockEntity instanceof StandingSignBlockEntity) {
                    StandingSignBlockEntity standingSignBlockEntity = (StandingSignBlockEntity)blockEntity;
                    class_3965 blockHitResult = buf.method_17814();
                    Boolean isFront = StandingSignBlock.getHitSide(blockEntity.method_11010(), blockHitResult);
                    if (isFront != null) {
                        client.execute(() -> client.method_1507((class_437)new StandingSignBlockEditScreen(standingSignBlockEntity, blockPos, isFront)));
                    }
                }
            }
            catch (ClassCastException | NullPointerException exception) {
                Mishanguc.MISHANG_LOGGER.error("Error when creating sign edit screen:", (Throwable)exception);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("mishanguc", "get_block_data"), (ClientPlayNetworking.PlayChannelHandler)new DataTagToolItem.BlockDataReceiver());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("mishanguc", "get_entity_data"), (ClientPlayNetworking.PlayChannelHandler)new DataTagToolItem.EntityDataReceiver());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("mishanguc", "rule_changed"), MishangucRules::handle);
    }

    private static void registerBlockColors() {
        Object[] coloredBlocks = (class_2248[])MishangUtils.blocks().stream().filter(Predicates.instanceOf(ColoredBlock.class)).toArray(class_2248[]::new);
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            class_2586 entity = world.method_8321(pos);
            if (entity == null) {
                entity = world.method_8321(pos.method_10074());
            }
            if (entity instanceof ColoredBlockEntity) {
                ColoredBlockEntity coloredBlockEntity = (ColoredBlockEntity)entity;
                return coloredBlockEntity.getColor();
            }
            int accumulatedNum = 0;
            int accumulatedRed = 0;
            int accumulatedGreen = 0;
            int accumulatedBlue = 0;
            for (class_2338 outPos : class_2338.method_25996((class_2338)pos, (int)1, (int)1, (int)1)) {
                class_2586 patt0$temp;
                if (outPos.equals((Object)pos) || !((patt0$temp = world.method_8321(outPos)) instanceof ColoredBlockEntity)) continue;
                ColoredBlockEntity coloredBlockEntity = (ColoredBlockEntity)patt0$temp;
                int color = coloredBlockEntity.getColor();
                ++accumulatedNum;
                accumulatedRed += color >> 16 & 0xFF;
                accumulatedGreen += color >> 8 & 0xFF;
                accumulatedBlue += color & 0xFF;
            }
            if (accumulatedNum > 0) {
                return (accumulatedRed / accumulatedNum << 16) + (accumulatedGreen / accumulatedNum << 8) + accumulatedBlue / accumulatedNum;
            }
            return -1;
        }, coloredBlocks);
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            class_2487 nbt = stack.method_7941("BlockEntityTag");
            if (nbt != null && nbt.method_10573("color", 99)) {
                return 0xFF000000 | nbt.method_10550("color");
            }
            return Color.HSBtoRGB((float)class_156.method_658() / 4096.0f + (float)(stack.method_7909().hashCode() >> 16) / 64.0f, 0.5f, 0.95f);
        }, coloredBlocks);
    }

    private static void registerBlockEntityRenderers() {
        class_5616.method_32144(MishangucBlockEntities.HUNG_SIGN_BLOCK_ENTITY, HungSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.COLORED_HUNG_SIGN_BLOCK_ENTITY, HungSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.WALL_SIGN_BLOCK_ENTITY, WallSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.COLORED_WALL_SIGN_BLOCK_ENTITY, WallSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.FULL_WALL_SIGN_BLOCK_ENTITY, WallSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.STANDING_SIGN_BLOCK_ENTITY, StandingSignBlockEntityRenderer::new);
        class_5616.method_32144(MishangucBlockEntities.COLORED_STANDING_SIGN_BLOCK_ENTITY, StandingSignBlockEntityRenderer::new);
    }

    private static void registerRenderEvents() {
        WorldRenderEvents.BLOCK_OUTLINE.register((Object)RendersBlockOutline.RENDERER);
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((Object)RendersBeforeOutline.RENDERER);
    }

    private static void registerBlockLayers() {
        ((ObjectArrayList)Validate.notEmpty(MishangucBlocks.translucentBlocks)).forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23583()));
        ((ObjectArrayList)Validate.notEmpty(MishangucBlocks.cutoutBlocks)).forEach(block -> {
            AbstractRoadBlock roadBlock;
            BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
            if (block instanceof AbstractRoadBlock && (roadBlock = (AbstractRoadBlock)block).getRoadSlab() != null) {
                BlockRenderLayerMap.INSTANCE.putBlock((class_2248)roadBlock.getRoadSlab(), class_1921.method_23581());
            }
        });
        MishangucBlocks.translucentBlocks = null;
        MishangucBlocks.cutoutBlocks = null;
    }
}

