/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc;

import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangucClient;
import pers.solid.mishang.uc.util.TextBridge;

@ApiStatus.AvailableSince(value="1.0.0")
public final class MishangucRules {
    public static final class_1928.class_4313<EnumRule<ToolAccess>> FORCE_PLACING_TOOL_ACCESS = MishangucRules.register("force_placing_tool_access", GameRuleFactory.createEnumRule((Enum)ToolAccess.CREATIVE_ONLY, (server, rule) -> MishangucRules.sync(server, rule, 0)));
    public static final class_1928.class_4313<EnumRule<ToolAccess>> CARRYING_TOOL_ACCESS = MishangucRules.register("carrying_tool_access", GameRuleFactory.createEnumRule((Enum)ToolAccess.ALL, (server, rule) -> MishangucRules.sync(server, rule, 1)));
    public static final class_1928.class_4313<EnumRule<ToolAccess>> EXPLOSION_TOOL_ACCESS = MishangucRules.register("explosion_tool_access", GameRuleFactory.createEnumRule((Enum)ToolAccess.ALL));

    private static void sync(MinecraftServer server, class_1928.class_4315<?> rule, int type) {
        for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
            MishangucRules.sync(rule, type, serverPlayerEntity);
        }
    }

    static void sync(class_1928.class_4315<?> rule, int type, class_3222 serverPlayerEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeShort(type);
        if (rule instanceof EnumRule) {
            buf.method_10817(((EnumRule)rule).get());
        } else if (rule instanceof class_1928.class_4310) {
            buf.writeBoolean(((class_1928.class_4310)rule).method_20753());
        } else if (rule instanceof DoubleRule) {
            buf.writeDouble(((DoubleRule)rule).get());
        }
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)new class_2960("mishanguc", "rule_changed"), (class_2540)buf);
    }

    private static <T extends class_1928.class_4315<T>> class_1928.class_4313<T> register(String name, class_1928.class_4314<T> ruleType) {
        return GameRuleRegistry.register((String)("mishanguc:" + name), (class_1928.class_5198)class_1928.class_5198.field_24100, ruleType);
    }

    static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        short type = buf.readShort();
        ToolAccess value = type == 0 || type == 1 ? (ToolAccess)buf.method_10818(ToolAccess.class) : null;
        boolean booleanValue = type == 2 && buf.readBoolean();
        double doubleValue = type == 3 ? buf.readDouble() : Double.NaN;
        client.execute(() -> {
            switch (type) {
                case 0: {
                    MishangucClient.CLIENT_FORCE_PLACING_TOOL_ACCESS.set(value);
                    break;
                }
                case 1: {
                    MishangucClient.CLIENT_CARRYING_TOOL_ACCESS.set(value);
                }
            }
        });
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ToolAccess implements class_3542
    {
        ALL{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return true;
            }
        }
        ,
        CREATIVE_ONLY{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return player != null && player.method_7337();
            }
        }
        ,
        OP_ONLY{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return player != null && player.method_5687(2);
            }
        }
        ,
        CREATIVE_OP_ONLY{

            @Override
            public boolean hasAccess(@Nullable class_1657 player) {
                return player != null && player.method_7337() && player.method_5687(2);
            }
        };

        private final String name = this.name().toLowerCase();

        public String method_15434() {
            return this.name;
        }

        @Contract(pure=true)
        public abstract boolean hasAccess(@Nullable class_1657 var1);

        public boolean hasAccess(class_1657 player, boolean warn) {
            boolean hasAccess = this.hasAccess(player);
            if (warn && !hasAccess && !player.method_37908().field_9236) {
                player.method_7353((class_2561)this.createWarnText(), true);
            }
            return hasAccess;
        }

        public class_5250 createWarnText() {
            return TextBridge.translatable("message.tool_access", TextBridge.translatable("message.tool_access." + this.method_15434())).method_27692(class_124.field_1061);
        }
    }
}

