/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2444;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4917;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.block.AbstractRoadSlabBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.blocks.RoadBlocks;
import pers.solid.mishang.uc.blocks.RoadSlabBlocks;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;

public abstract class AbstractRoadBlock
extends class_2248
implements Road {
    protected final LineColor lineColor;
    protected final LineType lineType;

    public AbstractRoadBlock(class_4970.class_2251 settings, LineColor lineColor, LineType lineType) {
        super(settings);
        this.lineColor = lineColor;
        this.lineType = lineType;
    }

    @Override
    public LineType getLineType(class_2680 state, class_2350 direction) {
        return this.lineType;
    }

    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        this.appendRoadProperties(builder);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.withPlacementState(super.method_9605(ctx), ctx);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return this.mirrorRoad(super.method_9569(state, mirror), mirror);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return this.rotateRoad(super.method_9598(state, rotation), rotation);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 result = super.method_9534(state, world, pos, player, hand, hit);
        if (result == class_1269.field_5814) {
            return result;
        }
        return this.onUseRoad(state, world, pos, player, hand, hit);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        this.neighborRoadUpdate(state, world, pos, sourceBlock, sourcePos, notify);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.withStateForNeighborUpdate(super.method_9559(state, direction, neighborState, world, pos, neighborPos), direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public LineColor getLineColor(class_2680 state, class_2350 direction) {
        return this.lineColor;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, world, tooltip, options);
        this.appendDescriptionTooltip(tooltip, options);
        this.appendRoadTooltip(stack, world, tooltip, options);
    }

    @ApiStatus.AvailableSince(value="1.1.0")
    @Contract(pure=true)
    public final AbstractRoadSlabBlock getRoadSlab() {
        return (AbstractRoadSlabBlock)RoadSlabBlocks.BLOCK_TO_SLABS.get((Object)this);
    }

    @Override
    public void writeRecipes(Consumer<class_2444> exporter) {
        Road.super.writeRecipes(exporter);
        class_5797 paintingRecipe = this.getPaintingRecipe(RoadBlocks.ROAD_BLOCK, this);
        if (paintingRecipe != null) {
            paintingRecipe.method_33529(this.getRecipeGroup()).method_17972(exporter, this.getPaintingRecipeId());
        }
    }

    @Override
    public final void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        this.registerBaseOrSlabModels(this, blockStateModelGenerator);
        blockStateModelGenerator.method_25623((class_2248)this, class_4941.method_25842((class_2248)this));
    }

    protected abstract <B extends class_2248> void registerBaseOrSlabModels(B var1, class_4910 var2);

    @Override
    public String getModelName(String suffix) {
        return "road" + suffix;
    }

    @Override
    public class_2960 uploadModel(String suffix, class_4944 textureMap, class_4910 blockStateModelGenerator, class_4945 ... textureKeys) {
        return MishangucModels.createBlock(this.getModelName(suffix), textureKeys).method_25846((class_2248)this, textureMap, blockStateModelGenerator.field_22831);
    }

    @Override
    public class_2960 uploadModel(String suffix, String variant, class_4944 textureMap, class_4910 blockStateModelGenerator, class_4945 ... textureKeys) {
        return MishangucModels.createBlock(this.getModelName(suffix), variant, textureKeys).method_25846((class_2248)this, textureMap, blockStateModelGenerator.field_22831);
    }

    @Override
    public class_4917 composeState(@NotNull class_4917 stateForFull) {
        return stateForFull;
    }
}

