/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import java.util.function.Function;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.block.HandrailBlock;
import pers.solid.mishang.uc.block.HandrailCentralBlock;
import pers.solid.mishang.uc.block.HandrailCornerBlock;
import pers.solid.mishang.uc.block.HandrailOuterBlock;
import pers.solid.mishang.uc.block.HandrailStairBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.util.TextBridge;

@ApiStatus.AvailableSince(value="0.2.4")
public class GlassHandrailBlock
extends HandrailBlock {
    public final class_2960 decorationTexture;
    private final CentralBlock central;
    private final CornerBlock corner;
    private final StairBlock stair;
    private final OuterBlock outer;
    private final class_2248 baseBlock;
    private final class_2960 frameTexture;
    public static final class_4945 FRAME = class_4945.method_27043((String)"frame");
    public static final class_4945 GLASS = class_4945.method_27043((String)"glass");
    public static final class_4945 DECORATION = class_4945.method_27043((String)"decoration");

    public GlassHandrailBlock(class_2248 baseBlock, class_4970.class_2251 settings, String frameTexture, String decorationTexture) {
        super(settings);
        this.baseBlock = baseBlock;
        this.frameTexture = new class_2960(frameTexture);
        this.decorationTexture = new class_2960(decorationTexture);
        this.central = new CentralBlock(this);
        this.corner = new CornerBlock(this);
        this.stair = new StairBlock(this);
        this.outer = new OuterBlock(this);
    }

    protected GlassHandrailBlock(class_2248 baseBlock, class_4970.class_2251 settings, String frameTexture, String decorationTexture, Function<GlassHandrailBlock, CentralBlock> centralProvider, Function<GlassHandrailBlock, CornerBlock> cornerProvider, Function<GlassHandrailBlock, StairBlock> stairProvider, Function<GlassHandrailBlock, OuterBlock> outerProvider) {
        super(settings.method_22488());
        this.baseBlock = baseBlock;
        this.frameTexture = new class_2960(frameTexture);
        this.decorationTexture = new class_2960(decorationTexture);
        this.central = centralProvider.apply(this);
        this.corner = cornerProvider.apply(this);
        this.stair = stairProvider.apply(this);
        this.outer = outerProvider.apply(this);
    }

    @Override
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_4944 textures = this.getTextures();
        class_2960 modelId = MishangucModels.GLASS_HANDRAIL.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
        MishangucModels.GLASS_HANDRAIL_INVENTORY.method_25852(class_4941.method_25840((class_1792)this.method_8389()), textures, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
    }

    @Override
    @NotNull
    public class_4944 getTextures() {
        return new class_4944().method_25868(FRAME, this.frameTexture).method_25868(GLASS, Mishanguc.id("block/glass_unframed")).method_25868(DECORATION, this.decorationTexture);
    }

    @Override
    public HandrailCentralBlock<? extends HandrailBlock> central() {
        return this.central;
    }

    @Override
    public HandrailCornerBlock<? extends HandrailBlock> corner() {
        return this.corner;
    }

    @Override
    public HandrailStairBlock<? extends HandrailBlock> stair() {
        return this.stair;
    }

    @Override
    public HandrailOuterBlock<? extends HandrailBlock> outer() {
        return this.outer;
    }

    @Override
    @Nullable
    public class_2248 baseBlock() {
        return this.baseBlock;
    }

    public static class CentralBlock
    extends HandrailCentralBlock<GlassHandrailBlock> {
        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_central", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        protected CentralBlock(@NotNull GlassHandrailBlock baseRail) {
            super(baseRail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseRail).nonOpaque());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_4944 textures = ((GlassHandrailBlock)this.baseHandrail).getTextures();
            class_2960 postModelId = MishangucModels.GLASS_HANDRAIL_POST.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            class_2960 sideModelId = MishangucModels.GLASS_HANDRAIL_SIDE.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            class_2960 postSideModelId = MishangucModels.GLASS_HANDRAIL_POST_SIDE.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(postModelId, postSideModelId, sideModelId));
        }
    }

    public static class CornerBlock
    extends HandrailCornerBlock<GlassHandrailBlock> {
        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_corner", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        protected CornerBlock(@NotNull GlassHandrailBlock baseRail) {
            super(baseRail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseRail).nonOpaque());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.GLASS_HANDRAIL_CORNER.method_25846((class_2248)this, ((GlassHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }
    }

    public static class StairBlock
    extends HandrailStairBlock<GlassHandrailBlock> {
        protected StairBlock(@NotNull GlassHandrailBlock baseRail) {
            super(baseRail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseRail).nonOpaque());
        }

        @Override
        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_stair", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_4944 textures = ((GlassHandrailBlock)this.baseHandrail).getTextures();
            class_2960 baseModelId = MishangucModels.createBlock("glass_handrail_stair_middle_center", FRAME, GLASS, DECORATION).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            for (HandrailStairBlock.Shape shape : HandrailStairBlock.Shape.values()) {
                for (HandrailStairBlock.Position position : HandrailStairBlock.Position.values()) {
                    MishangucModels.createBlock(String.format("glass_handrail_stair_%s_%s", shape.method_15434(), position.method_15434()), "_" + shape.method_15434() + "_" + position.method_15434(), FRAME, GLASS, DECORATION).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
                }
            }
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(baseModelId));
        }
    }

    public static class OuterBlock
    extends HandrailOuterBlock<GlassHandrailBlock> {
        protected OuterBlock(@NotNull GlassHandrailBlock baseRail) {
            super(baseRail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseRail).nonOpaque());
        }

        public class_5250 method_9518() {
            return TextBridge.translatable("block.mishanguc.handrail_outer", ((GlassHandrailBlock)this.baseHandrail).method_9518());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.GLASS_HANDRAIL_OUTER.method_25846((class_2248)this, ((GlassHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }
    }
}

