/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_184;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4970;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.MishangucProperties;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.block.Road;
import pers.solid.mishang.uc.data.FasterTextureMap;
import pers.solid.mishang.uc.data.MishangucTextureKeys;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.RoadConnectionState;
import pers.solid.mishang.uc.util.TextBridge;

public interface RoadWithAngleLine
extends Road {
    public static final class_2754<HorizontalCornerDirection> FACING = MishangucProperties.HORIZONTAL_CORNER_FACING;

    @Override
    default public void appendRoadProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    default public RoadConnectionState getConnectionStateOf(class_2680 state, class_2350 direction) {
        return RoadConnectionState.of(((HorizontalCornerDirection)((Object)state.method_11654(FACING))).hasDirection(direction), this.getLineColor(state, direction), this.isBevel() ? EightHorizontalDirection.of(((HorizontalCornerDirection)((Object)state.method_11654(FACING))).mirror(direction)) : EightHorizontalDirection.of(direction), this.getLineType(state, direction), null);
    }

    @Override
    default public class_2680 mirrorRoad(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(FACING, (Comparable)((Object)((HorizontalCornerDirection)((Object)state.method_11654(FACING))).mirror(mirror)));
    }

    @Override
    default public class_2680 rotateRoad(class_2680 state, class_2470 rotation) {
        HorizontalCornerDirection facing = (HorizontalCornerDirection)((Object)state.method_11654(FACING));
        return (class_2680)state.method_11657(FACING, (Comparable)((Object)facing.rotate(rotation)));
    }

    @Override
    default public class_2680 withPlacementState(class_2680 state, class_1750 ctx) {
        if (state == null) {
            return null;
        }
        HorizontalCornerDirection rotation = HorizontalCornerDirection.fromRotation(ctx.method_8044());
        return (class_2680)state.method_11657(FACING, (Comparable)((Object)(ctx.method_8036() != null && ctx.method_8036().method_5715() ? rotation.getOpposite() : rotation)));
    }

    @Override
    default public void appendRoadTooltip(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        Road.super.appendRoadTooltip(stack, world, tooltip, options);
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_angle_line.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("block.mishanguc.tooltip.road_with_angle_line.2").method_27692(class_124.field_1080));
    }

    public boolean isBevel();

    public static class Impl
    extends AbstractRoadBlock
    implements RoadWithAngleLine {
        private final boolean isBevel;
        protected final String lineSide;
        protected final String lineTop;
        private static final String[] NORMAL_BEVEL_PATTERN = new String[]{" *X", "*X ", "X  "};
        private static final String[] DOUBLE_BEVEL_PATTERN = new String[]{" *X", "*X*", "X* "};
        private static final String[] THICK_BEVEL_PATTERN = new String[]{"**X", "*X*", "X**"};
        private static final String[] NORMAL_RIGHT_ANGLE_PATTERN = new String[]{" * ", "*XX", " X "};

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineType lineType, boolean isBevel, String lineTop) {
            this(settings, lineColor, lineType, MishangUtils.composeStraightLineTexture(lineColor, lineType), isBevel, lineTop);
        }

        public Impl(class_4970.class_2251 settings, LineColor lineColor, LineType lineType, String lineSide, boolean isBevel, String lineTop) {
            super(settings, lineColor, lineType);
            this.isBevel = isBevel;
            this.lineSide = lineSide;
            this.lineTop = lineTop;
        }

        @Override
        public boolean isBevel() {
            return this.isBevel;
        }

        @Override
        protected <B extends class_2248> void registerBaseOrSlabModels(B road, class_4910 blockStateModelGenerator) {
            FasterTextureMap textures = new FasterTextureMap().base("asphalt").lineSide(this.lineSide).lineTop(this.lineTop);
            class_2960 modelId = ((Road)road).uploadModel("_with_angle_line", textures, blockStateModelGenerator, MishangucTextureKeys.BASE, MishangucTextureKeys.LINE_SIDE, MishangucTextureKeys.LINE_TOP);
            blockStateModelGenerator.field_22830.accept(((Road)road).composeState((class_4917)class_4925.method_25770(road, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId)).method_25775(class_4926.method_25783((class_2769)FACING).method_25795(direction -> class_4935.method_25824().method_25828(MishangUtils.INT_Y_VARIANT, (Object)(direction.asRotation() - 45))))));
        }

        @Override
        public void appendDescriptionTooltip(List<class_2561> tooltip, class_1836 options) {
            if (this.isBevel()) {
                tooltip.add((class_2561)TextBridge.translatable("lineType.angle.bevel").method_27692(class_124.field_1078));
            } else {
                tooltip.add((class_2561)TextBridge.translatable("lineType.angle.right").method_27692(class_124.field_1078));
            }
            tooltip.add((class_2561)TextBridge.translatable("lineType.angle.composed", this.lineColor.getName(), this.lineType.getName()).method_27692(class_124.field_1078));
        }

        @Override
        public class_5797 getPaintingRecipe(class_2248 base, class_2248 self) {
            String[] stringArray;
            if (this.isBevel) {
                switch (this.lineType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORMAL: {
                        stringArray = NORMAL_BEVEL_PATTERN;
                        break;
                    }
                    case DOUBLE: {
                        stringArray = DOUBLE_BEVEL_PATTERN;
                        break;
                    }
                    case THICK: {
                        stringArray = THICK_BEVEL_PATTERN;
                        break;
                    }
                }
            } else {
                stringArray = NORMAL_RIGHT_ANGLE_PATTERN;
            }
            String[] patterns = stringArray;
            return class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)self, (int)3).method_10439(patterns[0]).method_10439(patterns[1]).method_10439(patterns[2]).method_10433(Character.valueOf('*'), this.lineColor.getIngredient()).method_10434(Character.valueOf('X'), (class_1935)base).method_10429("*", (class_184)class_2446.method_10420(this.lineColor.getIngredient())).method_10429(class_2446.method_32807((class_1935)base), (class_184)class_2446.method_10426((class_1935)base));
        }
    }
}

