/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.block;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_4910;
import net.minecraft.class_4916;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.block.ColoredBlock;
import pers.solid.mishang.uc.block.HandrailBlock;
import pers.solid.mishang.uc.block.HandrailCentralBlock;
import pers.solid.mishang.uc.block.HandrailCornerBlock;
import pers.solid.mishang.uc.block.HandrailOuterBlock;
import pers.solid.mishang.uc.block.HandrailStairBlock;
import pers.solid.mishang.uc.data.MishangucModels;
import pers.solid.mishang.uc.util.TextBridge;

public class SimpleHandrailBlock
extends HandrailBlock {
    @Nullable
    public final class_2248 baseBlock;
    public final CentralBlock central;
    public final CornerBlock corner;
    public final StairBlock stair;
    public final OuterBlock outer;
    @Nullable
    public class_2960 texture;
    @Nullable
    public class_2960 top;
    @Nullable
    public class_2960 bottom;

    public SimpleHandrailBlock(@Nullable class_2248 baseBlock, class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.baseBlock = baseBlock;
        this.central = new CentralBlock(this);
        this.corner = new CornerBlock(this);
        this.stair = new StairBlock(this);
        this.outer = new OuterBlock(this);
    }

    public SimpleHandrailBlock(@NotNull class_2248 baseBlock) {
        this(baseBlock, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseBlock));
    }

    @Override
    public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
        class_4944 textures = this.getTextures();
        class_2960 modelId = MishangucModels.SIMPLE_HANDRAIL.method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
        MishangucModels.SIMPLE_HANDRAIL_INVENTORY.method_25852(class_4941.method_25840((class_1792)this.method_8389()), textures, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
    }

    @Override
    @NotNull
    public class_4944 getTextures() {
        return class_4944.method_25875((class_2960)this.getTexture()).method_25868(class_4945.field_23015, this.top).method_25868(class_4945.field_23014, this.bottom);
    }

    public final HandrailCentralBlock<SimpleHandrailBlock> central() {
        return this.central;
    }

    @Override
    public HandrailCornerBlock<? extends HandrailBlock> corner() {
        return this.corner;
    }

    @Override
    public HandrailStairBlock<? extends HandrailBlock> stair() {
        return this.stair;
    }

    @Override
    public HandrailOuterBlock<? extends HandrailBlock> outer() {
        return this.outer;
    }

    @Override
    @Nullable
    public class_2248 baseBlock() {
        return this.baseBlock;
    }

    protected class_2960 getTexture() {
        return this.texture == null ? class_4944.method_25860((class_2248)this.baseBlock) : this.texture;
    }

    public class_5250 method_9518() {
        if (this.baseBlock != null) {
            return TextBridge.translatable("block.mishanguc.simple_handrail", this.baseBlock.method_9518());
        }
        return super.method_9518();
    }

    private String getRecipeGroup() {
        if (this.baseBlock instanceof ColoredBlock) {
            return null;
        }
        if (MishangUtils.isConcrete(this.baseBlock)) {
            return "mishanguc:simple_concrete_handrail";
        }
        if (MishangUtils.isTerracotta(this.baseBlock)) {
            return "mishanguc:simple_terracotta_handrail";
        }
        if (MishangUtils.isStained_glass(this.baseBlock)) {
            return "mishanguc:simple_stained_glass_handrail";
        }
        if (MishangUtils.isWood(this.baseBlock)) {
            return "mishanguc:simple_wood_handrail";
        }
        if (MishangUtils.isPlanks(this.baseBlock)) {
            return "mishanguc:simple_plank_handrail";
        }
        if (this.baseBlock == class_2246.field_10295 || this.baseBlock == class_2246.field_10225 || this.baseBlock == class_2246.field_10384) {
            return "mishanguc:simple_ice_handrail";
        }
        return null;
    }

    @Override
    public class_5797 getCraftingRecipe() {
        return class_3981.method_17969((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{this.baseBlock}), (class_7800)class_7800.field_40635, (class_1935)this, (int)5).method_17970(class_2446.method_32807((class_1935)this.baseBlock), (class_184)class_2446.method_10426((class_1935)this.baseBlock)).method_35919(this.getRecipeGroup());
    }

    public static class CentralBlock
    extends HandrailCentralBlock<SimpleHandrailBlock> {
        public CentralBlock(@NotNull SimpleHandrailBlock baseBlock) {
            super(baseBlock, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseBlock).nonOpaque());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 postModelId = MishangucModels.SIMPLE_HANDRAIL_POST.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            class_2960 sideModelId = MishangucModels.SIMPLE_HANDRAIL_SIDE.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            class_2960 postSideModelId = MishangucModels.SIMPLE_HANDRAIL_POST_SIDE.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(postModelId, postSideModelId, sideModelId));
        }

        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_central", block.method_9518());
        }
    }

    public static class CornerBlock
    extends HandrailCornerBlock<SimpleHandrailBlock> {
        public CornerBlock(@NotNull SimpleHandrailBlock baseHandrail) {
            super(baseHandrail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseHandrail).nonOpaque());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.SIMPLE_HANDRAIL_CORNER.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }

        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_corner", block.method_9518());
        }
    }

    public static class StairBlock
    extends HandrailStairBlock<SimpleHandrailBlock> {
        public StairBlock(@NotNull SimpleHandrailBlock baseRail) {
            super(baseRail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseRail).nonOpaque());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_4944 textures = ((SimpleHandrailBlock)this.baseHandrail).getTextures();
            class_2960 baseModelId = MishangucModels.createBlock("simple_handrail_stair_middle_center", class_4945.field_23011, class_4945.field_23015, class_4945.field_23014).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
            for (HandrailStairBlock.Shape shape : HandrailStairBlock.Shape.values()) {
                for (HandrailStairBlock.Position position : HandrailStairBlock.Position.values()) {
                    MishangucModels.createBlock(String.format("simple_handrail_stair_%s_%s", shape.method_15434(), position.method_15434()), "_" + shape.method_15434() + "_" + position.method_15434(), class_4945.field_23011, class_4945.field_23015, class_4945.field_23014).method_25846((class_2248)this, textures, blockStateModelGenerator.field_22831);
                }
            }
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(baseModelId));
        }

        @Override
        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_stair", block.method_9518());
        }
    }

    public static class OuterBlock
    extends HandrailOuterBlock<SimpleHandrailBlock> {
        public OuterBlock(@NotNull SimpleHandrailBlock baseRail) {
            super(baseRail, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)baseRail).nonOpaque());
        }

        @Override
        public void registerModels(class_4916 modelProvider, class_4910 blockStateModelGenerator) {
            class_2960 modelId = MishangucModels.SIMPLE_HANDRAIL_OUTER.method_25846((class_2248)this, ((SimpleHandrailBlock)this.baseHandrail).getTextures(), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(this.createBlockStates(modelId));
        }

        public class_5250 method_9518() {
            class_2248 block = this.baseBlock();
            return block == null ? super.method_9518() : TextBridge.translatable("block.mishanguc.simple_handrail_outer", block.method_9518());
        }
    }
}

