/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.blockentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.mishang.uc.blockentity.HungSignBlockEntity;
import pers.solid.mishang.uc.blockentity.StandingSignBlockEntity;
import pers.solid.mishang.uc.blockentity.WallSignBlockEntity;
import pers.solid.mishang.uc.text.TextContext;
import pers.solid.mishang.uc.util.TextBridge;

public abstract class BlockEntityWithText
extends class_2586 {
    public static final class_2561 MESSAGE_GLOW_ON = TextBridge.translatable("message.mishanguc.sign.glow_on");
    public static final class_2561 MESSAGE_GLOW_OFF = TextBridge.translatable("message.mishanguc.sign.glow_off");
    public static final class_2561 MESSAGE_WAX_ON = TextBridge.translatable("message.mishanguc.sign.wax_on");
    public static final class_2561 MESSAGE_WAX_OFF = TextBridge.translatable("message.mishanguc.sign.wax_off");
    public static final PacketHandler PACKET_HANDLER = new PacketHandler();

    public BlockEntityWithText(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public abstract @Range(from=0L, to=16L) float getHeight();

    @Contract(value="-> new")
    public abstract TextContext createDefaultTextContext();

    @Nullable
    public abstract class_1657 getEditor();

    public abstract void setEditor(@Nullable class_1657 var1);

    public void checkEditorValidity() {
        class_1657 editor = this.getEditor();
        if (editor != null && editor.method_7325() && !editor.method_5709() && editor.method_37908() != this.field_11863) {
            this.setEditor(null);
        }
    }

    public void markDirtyAndUpdate() {
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public static class PacketHandler
    implements ServerPlayNetworking.PlayChannelHandler {
        protected static final Logger LOGGER = LoggerFactory.getLogger(PacketHandler.class);

        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            LOGGER.info("Server side sign_edit_finish packet received!");
            class_2338 blockPos = buf.method_10811();
            class_2487 nbt = buf.method_10798();
            server.execute(() -> {
                try {
                    ImmutableList textContexts;
                    BlockEntityWithText entity = (BlockEntityWithText)player.method_37908().method_8321(blockPos);
                    if (entity == null) {
                        LOGGER.warn("The entity is null! Cannot write the block entity data at {} {} {}.", new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
                        return;
                    }
                    class_1657 editorAllowed = entity.getEditor();
                    entity.setEditor(null);
                    ImmutableList immutableList = textContexts = nbt != null ? (ImmutableList)nbt.method_10554("texts", 10).stream().map(e -> TextContext.fromNbt(e, entity.createDefaultTextContext())).collect(ImmutableList.toImmutableList()) : null;
                    if (editorAllowed != player) {
                        LOGGER.warn("The player editing the block entity {} {} {} is not the player allowed to edit.", new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
                        return;
                    }
                    if (entity instanceof HungSignBlockEntity) {
                        HungSignBlockEntity hungSignBlockEntity = (HungSignBlockEntity)entity;
                        class_2350 editedSide = hungSignBlockEntity.editedSide;
                        hungSignBlockEntity.editedSide = null;
                        if (nbt == null) {
                            return;
                        }
                        HashMap<@NotNull class_2350, @NotNull List<@NotNull TextContext>> builder = new HashMap<class_2350, List<TextContext>>(hungSignBlockEntity.texts);
                        if (editedSide != null) {
                            if (!textContexts.isEmpty()) {
                                builder.put(editedSide, (List<TextContext>)textContexts);
                            } else {
                                builder.remove(editedSide);
                            }
                        }
                        hungSignBlockEntity.texts = ImmutableMap.copyOf(builder);
                    } else if (entity instanceof WallSignBlockEntity) {
                        WallSignBlockEntity wallSignBlockEntity = (WallSignBlockEntity)entity;
                        if (nbt == null) {
                            return;
                        }
                        wallSignBlockEntity.textContexts = textContexts;
                    } else if (entity instanceof StandingSignBlockEntity) {
                        StandingSignBlockEntity standingSignBlockEntity = (StandingSignBlockEntity)entity;
                        Boolean editedSite = standingSignBlockEntity.editedSide;
                        if (editedSite != null && nbt != null) {
                            standingSignBlockEntity.setTextsOnSide(editedSite, (List<TextContext>)textContexts);
                        }
                    }
                    if (entity.method_10997() != null) {
                        entity.method_10997().method_8413(entity.field_11867, entity.method_11010(), entity.method_11010(), 2);
                    }
                    entity.method_5431();
                }
                catch (ClassCastException e2) {
                    LOGGER.error("Error when trying to parse NBT received: ", (Throwable)e2);
                }
            });
        }
    }
}

