/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.blockentity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.booleans.BooleanArraySet;
import it.unimi.dsi.fastutil.booleans.BooleanSet;
import it.unimi.dsi.fastutil.booleans.BooleanSets;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import pers.solid.mishang.uc.blockentity.BlockEntityWithText;
import pers.solid.mishang.uc.blockentity.MishangucBlockEntities;
import pers.solid.mishang.uc.text.TextContext;

@ApiStatus.AvailableSince(value="1.0.2")
public class StandingSignBlockEntity
extends BlockEntityWithText {
    public static final TextContext DEFAULT_TEXT_CONTEXT = (TextContext)class_156.method_654((Object)new TextContext(), textContext -> {
        textContext.size = 6.0f;
    });
    @NotNull
    public List<TextContext> frontTexts = ImmutableList.of();
    @NotNull
    public List<TextContext> backTexts = ImmutableList.of();
    @Nullable
    private class_1657 editor;
    @Nullable
    public Boolean editedSide;
    public BooleanSet waxed = BooleanSets.emptySet();
    public BooleanSet glowing = BooleanSets.emptySet();

    public StandingSignBlockEntity(class_2338 pos, class_2680 state) {
        super(MishangucBlockEntities.STANDING_SIGN_BLOCK_ENTITY, pos, state);
    }

    protected StandingSignBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2520 nbtFrontTexts = nbt.method_10580("frontTexts");
        if (nbtFrontTexts instanceof class_2499) {
            class_2499 nbtList = (class_2499)nbtFrontTexts;
            this.frontTexts = (List)nbtList.stream().map(nbtElement -> TextContext.fromNbt(nbtElement, this.createDefaultTextContext())).collect(ImmutableList.toImmutableList());
        } else {
            this.frontTexts = ImmutableList.of((Object)TextContext.fromNbt(nbtFrontTexts, this.createDefaultTextContext()));
        }
        class_2520 nbtBackTexts = nbt.method_10580("backTexts");
        if (nbtBackTexts instanceof class_2499) {
            class_2499 nbtList = (class_2499)nbtBackTexts;
            this.backTexts = (List)nbtList.stream().map(nbtElement -> TextContext.fromNbt(nbtElement, this.createDefaultTextContext())).collect(ImmutableList.toImmutableList());
        } else {
            this.backTexts = ImmutableList.of((Object)TextContext.fromNbt(nbtBackTexts, this.createDefaultTextContext()));
        }
        boolean frontWaxed = nbt.method_10577("frontWaxed");
        boolean backWaxed = nbt.method_10577("backWaxed");
        if (!frontWaxed && !backWaxed) {
            this.waxed = BooleanSets.emptySet();
        } else {
            this.waxed = new BooleanArraySet(2);
            if (frontWaxed) {
                this.waxed.add(true);
            }
            if (backWaxed) {
                this.waxed.add(false);
            }
        }
        boolean frontGlowing = nbt.method_10577("frontGlowing");
        boolean backGlowing = nbt.method_10577("backGlowing");
        if (!frontGlowing && !backGlowing) {
            this.glowing = BooleanSets.emptySet();
        } else {
            this.glowing = new BooleanArraySet(2);
            if (frontGlowing) {
                this.glowing.add(true);
            }
            if (backGlowing) {
                this.glowing.add(false);
            }
        }
    }

    protected void method_11007(class_2487 nbt) {
        class_2499 nbtList;
        super.method_11007(nbt);
        if (this.frontTexts.size() == 1) {
            nbt.method_10566("frontTexts", (class_2520)this.frontTexts.get(0).createNbt());
        } else {
            nbtList = new class_2499();
            this.frontTexts.forEach(textContext -> nbtList.add((Object)textContext.createNbt()));
            nbt.method_10566("frontTexts", (class_2520)nbtList);
        }
        if (this.backTexts.size() == 1) {
            nbt.method_10566("backTexts", (class_2520)this.backTexts.get(0).createNbt());
        } else {
            nbtList = new class_2499();
            this.backTexts.forEach(textContext -> nbtList.add((Object)textContext.createNbt()));
            nbt.method_10566("backTexts", (class_2520)nbtList);
        }
        nbt.method_10556("frontWaxed", this.waxed.contains(true));
        nbt.method_10556("backWaxed", this.waxed.contains(false));
        nbt.method_10556("frontGlowing", this.glowing.contains(true));
        nbt.method_10556("backGlowing", this.glowing.contains(false));
    }

    @Override
    public @Range(from=0L, to=16L) float getHeight() {
        return 8.0f;
    }

    @Override
    public TextContext createDefaultTextContext() {
        return DEFAULT_TEXT_CONTEXT.clone();
    }

    @Override
    @Nullable
    public class_1657 getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(@Nullable class_1657 editor) {
        this.editor = editor;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Contract(pure=true)
    public List<TextContext> getTextsOnSide(boolean isFront) {
        return isFront ? this.frontTexts : this.backTexts;
    }

    @Contract(mutates="this")
    public void setTextsOnSide(boolean isFront, @NotNull List<TextContext> texts) {
        if (isFront) {
            this.frontTexts = texts;
        } else {
            this.backTexts = texts;
        }
    }
}

