/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.MishangucItem;
import pers.solid.mishang.uc.util.TextBridge;

public class BlockStateToolItem
extends BlockToolItem
implements MishangucItem {
    public BlockStateToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings, includesFluid);
    }

    public static void broadcastProperties(class_2338 blockPos, class_1657 player, class_2680 blockState) {
        Collection properties = blockState.method_28501();
        if (properties.isEmpty()) {
            player.method_7353((class_2561)TextBridge.translatable("debug.mishanguc.blockStates.none", String.format("%s %s %s", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), blockState.method_26204().method_9518().method_27692(class_124.field_1067)).method_27692(class_124.field_1061), false);
        } else {
            player.method_7353((class_2561)TextBridge.translatable("debug.mishanguc.blockStates", String.format("%s %s %s", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), blockState.method_26204().method_9518().method_27692(class_124.field_1067)).method_27692(class_124.field_1054), false);
        }
        for (class_2769 property : properties) {
            class_5250 value = BlockStateToolItem.getFormattedValue(blockState, property);
            player.method_7353((class_2561)TextBridge.literal("  ").method_10852((class_2561)TextBridge.literal(property.method_11899()).method_27694(style -> style.method_36139(0xCCCCCC))).method_27693(" = ").method_10852((class_2561)value), false);
        }
    }

    @NotNull
    private static <T extends Comparable<T>> class_5250 getFormattedValue(class_2680 blockState, class_2769<T> property) {
        Comparable propertyValue = blockState.method_11654(property);
        class_5250 value = TextBridge.literal(property.method_11901(propertyValue));
        if (property instanceof class_2746) {
            value.method_27692(propertyValue == Boolean.TRUE ? class_124.field_1060 : class_124.field_1061);
        } else if (property instanceof class_2758) {
            value.method_27694(style -> style.method_36139(61149));
        }
        return value;
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        if (world.field_9236) {
            return this.getBlockStateOf(player, world, blockHitResult.method_17777(), fluidIncluded);
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        if (!world.method_8608()) {
            return class_1269.field_5812;
        }
        return this.getBlockStateOf(player, world, pos, fluidIncluded);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return super.method_7885(state, world, pos, miner);
    }

    public class_1269 getBlockStateOf(class_1657 player, class_1937 world, class_2338 blockPos, boolean fluidIncluded) {
        class_3610 fluidState;
        int fluidLevel;
        class_2680 blockState = world.method_8320(blockPos);
        BlockStateToolItem.broadcastProperties(blockPos, player, blockState);
        if (fluidIncluded && (fluidLevel = (fluidState = world.method_8316(blockPos)).method_15761()) != 0) {
            player.method_7353((class_2561)TextBridge.literal("  ").method_10852((class_2561)TextBridge.translatable("debug.mishanguc.blockStates.fluidLevel").method_27694(style -> style.method_36139(0xCCCCCC))).method_27693(" = ").method_27693(String.valueOf(fluidLevel)), false);
        }
        return class_1269.field_5812;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.block_state_tool.tooltip").method_27692(class_124.field_1080));
        Boolean includesFluid = this.includesFluid(stack);
        if (includesFluid == null) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.block_state_tool.tooltip.includesFluidWhileSneaking").method_27692(class_124.field_1080));
        } else if (includesFluid.booleanValue()) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.block_state_tool.tooltip.includesFluid").method_27692(class_124.field_1080));
        }
    }
}

